#!/bin/sh

. ./_blfsset.sh

TARGET=blfs-systemd-units-$S_BOOTSCRIPTDATE
SCRIPT=install-winbindd
TARGETBALL=$DLD/$TARGET.tar.bz2
TARGETDIR=$TARGET

echo $SCRIPT

. $WRK/_checkRequired.sh samba
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

Installing
porg -lp "$SCRIPT" "make $SCRIPT" \
	1> $LOG/${SCRIPT}_1.install.log 2>&1 || (echo Error occured && exit 1)

TimeEnd

cd ..
RemoveSrcDir
PorgingDone $SCRIPT

