#!/bin/sh

APPNAME=rubygems
VER=1.8.24
TARGET=$APPNAME-$VER
TARGETBALL=$TARGET.tgz
TARGETDIR=$TARGET

. ./_blfsset.sh

echo $TARGET

echo \ \ Check Required...
./_checkRequired.sh ruby || exit 1

echo -n Tarball $TARGETBALL" "
if [ -e $DLD/$TARGETBALL ]; then
  echo  found
else
  echo  not found && exit 1
fi

if test "$1" == "check"; then
  exit 0
fi

cd $SRC

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

START=`date +'%Y/%m/%d %H:%M:%S.%N'`

cd $TARGETDIR

echo \ \ Setup...
paco -p $TARGET "ruby setup.rb" \
	1> $LOG/$TARGET.1_setup.log 2>&1 || exit 1

END=`date +'%Y/%m/%d %H:%M:%S.%N'`

echo `cat /etc/lfs-release`,$TARGET,$START,$END \
        >> $TME/$APPNAME.txt

echo -n \ \ Pacoing:\   && paco $TARGET || echo none

echo \ \ Removing directory...
cd .. && rm -fr $TARGETDIR

