#!/bin/sh

. ./_blfsset.sh

APPNAME=Python
APPVER=3
VER=3.8.2
TARGET=$APPNAME-$VER
TARGETBALL=/mnt/lfs/download/LFS/$TARGET.tar.xz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh ""
. $WRK/_checkOptions.sh  \
	bluez gdb valgrind \
	db sqlite
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

Configuring
CXX="/usr/bin/g++"              \
./configure --prefix=/usr       \
            --enable-shared     \
            --with-system-expat \
            --with-system-ffi   \
            --with-ensurepip=yes \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
porg -lp  $TARGET -E/tmp:`pwd` "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

chmod 755 /usr/lib/libpython3.8.so
chmod 755 /usr/lib/libpython3.so

porg -lp+  $TARGET "\
ln -sfn python-$VER /usr/share/doc/python-3" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PorgingDone

