#!/bin/sh

. ./_blfsset.sh
. ./Xorg/_xorgset.sh

APPNAME=pygobject
APPVER=3
VER=3.10.1
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.xz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	py2cairo gobject-introspection
. $WRK/_checkOptions.sh  \
	libxslt
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

mkdir python2
pushd python2

Configuring
../configure --prefix=/usr --with-python=/usr/bin/python \
	1> $LOG/$TARGET.1_conf2.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make2.log 2>&1 || exit 1
popd

mkdir python3
pushd python3

Configuring
../configure --prefix=/usr --with-python=/usr/bin/python3 \
        1> $LOG/$TARGET.1_conf3.log 2>&1 || exit 1

Making
make \
        1> $LOG/$TARGET.2_make3.log 2>&1 || exit 1
popd

Installing
paco -p  $TARGET "\
make -C python2 install" \
	1> $LOG/$TARGET.3_install2.log 2>&1 || echo Error occured!

paco -p+ $TARGET "\
make -C python3 install" \
        1> $LOG/$TARGET.3_install3.log 2>&1 || echo Error occured!

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

