#!/bin/sh

. ./_blfsset.sh

APPNAME=procmail
VER=3.22
TARGET=$APPNAME-$VER
TARGETBALL=$TARGET.tar.gz
TARGETDIR=$TARGET

echo $TARGET

echo Check Required...
./_checkRequired.sh || exit 1

if test "$1" == "check"; then
  exit 0
fi

cd $SRC

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

START=`date +'%Y/%m/%d %H:%M:%S.%N'`

cd $TARGETDIR

sed -i 's/getline/get_line/' src/*.[ch]

echo \ \ Making...
make LOCKINGTEST=/tmp install \
	1> $LOG/$TARGET.1_make.log 2>&1 || exit 1

echo \ \ Installing...
paco -p $TARGET "make install-suid" \
	1> $LOG/$TARGET.2_install.log 2>&1 || exit 1

END=`date +'%Y/%m/%d %H:%M:%S.%N'`

echo `cat /etc/lfs-release`,$TARGET,$START,$END \
        >> $TME/$APPNAME.txt

echo -n \ \ Pacoing:\   && paco $TARGET || echo none

echo \ \ Removing directory...
cd .. && rm -fr $TARGETDIR

