#!/bin/sh

. ./_blfsset.sh

APPNAME=openssl
VER=1.1.0g
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.gz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh ""
. $WRK/_checkOptions.sh  \
	krb5
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

unset MAKEFLAGS

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

Configuring
./config --prefix=/usr                  \
         --openssldir=/etc/ssl          \
         --libdir=lib                   \
         shared                         \
         zlib-dynamic                   \
         $([ ${OPTION_krb5} -eq "1" ] && echo --with-krb5-flavor=MIT) \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

#sed -i 's# libcrypto.a##;s# libssl.a##;/INSTALL_LIBS/s#libcrypto.a##' Makefile

Making
make -j1 \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
porg -lp $TARGET "\
make MANSUFFIX=ssl install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

porg -lp+ $TARGET "\
mv -v /usr/share/doc/openssl{,-1.1.0g}" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

porg -lp+ $TARGET "\
cp -vfr doc/* /usr/share/doc/openssl-1.1.0g" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PorgingDone

