#!/bin/sh

. ./_blfsset.sh

APPNAME=openjpeg
VER=2.3.0
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.gz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	cmake
. $WRK/_checkOptions.sh  \
	lcms2 libpng libtiff doxygen
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

patch -Np1 -i $DLD/openjpeg-$VER-only_shared-1.patch \
	1> $LOG/$TARGET.0_patch.log 2>&1 || exit 1

mkdir build
cd    build

Configuring
cmake -DCMAKE_BUILD_TYPE=Release \
      -DCMAKE_INSTALL_PREFIX=/usr \
      -DBUILD_STATIC_LIBS=OFF .. \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
porg -lp $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ../..
RemoveSrcDir
PorgingDone

