#!/bin/sh

. ./_blfsset.sh

APPNAME=OpenJDK
VER=10.0.1
VERADD=+10
TARGET=$APPNAME-$VER
if test $(uname -m) = i686; then
TARGETDIR=$APPNAME-${VER}${VERADD}-i686-bin
TARGETBALL=$DLD/$APPNAME-${VER}${VERADD}-i686-bin.tar.xz
else
TARGETDIR=$APPNAME-$VER$VERADD-x86_64-bin
TARGETBALL=$DLD/$APPNAME-$VER$VERADD-x86_64-bin.tar.xz
fi

echo $TARGET \($(uname -m)\)

. $WRK/_checkRequired.sh ""
. $WRK/_checkOptions.sh  \
	alsa-lib cups giflib
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR || (echo Not found directory: $TARGETDIR && exit 1)

install -vdm755 /opt/OpenJDK-$VER$VERADD-bin

porg -lp+ $TARGET "mv -v * /opt/OpenJDK-$VER$VERADD-bin" \
	1> $LOG/$TARGET.1_move.log 2>&1 || exit 1

chown -v -R root:root /opt/OpenJDK-$VER$VERADD-bin \
	1> $LOG/$TARGET.2_chown.log 2>&1 || exit 1

export CLASSPATH=".:/usr/share/java"
export JAVA_HOME="/opt/OpenJDK-$VER$VERADD-bin"
export PATH="$PATH:${JAVA_HOME}/bin"

porg -lp+ $TARGET "\
ln -v -sfn OpenJDK-$VER$VERADD-bin /opt/jdk"

cat > /etc/profile.d/openjdk.sh << "EOF"
# Begin /etc/profile.d/openjdk.sh

# Set JAVA_HOME directory
JAVA_HOME=/opt/jdk

# Adjust PATH
pathappend $JAVA_HOME/bin

# Add to MANPATH
pathappend $JAVA_HOME/man MANPATH

# Auto Java CLASSPATH: Copy jar files to, or create symlinks in, the
# /usr/share/java directory. Note that having gcj jars with OpenJDK 8
# may lead to errors.

AUTO_CLASSPATH_DIR=/usr/share/java

pathprepend . CLASSPATH

for dir in `find ${AUTO_CLASSPATH_DIR} -type d 2>/dev/null`; do
    pathappend $dir CLASSPATH
done

for jar in `find ${AUTO_CLASSPATH_DIR} -name "*.jar" 2>/dev/null`; do
    pathappend $jar CLASSPATH
done

export JAVA_HOME
unset AUTO_CLASSPATH_DIR dir jar

# End /etc/profile.d/openjdk.sh
EOF

porg -lp+ $TARGET "touch /etc/profile.d/openjdk.sh"

cat >> /etc/man_db.conf << "EOF" &&
# Begin Java addition
MANDATORY_MANPATH     /opt/jdk/man
MANPATH_MAP           /opt/jdk/bin     /opt/jdk/man
MANDB_MAP             /opt/jdk/man     /var/cache/man/jdk
# End Java addition
EOF

porg -lp+ $TARGET "touch /etc/man_db.conf "

mkdir -p /var/cache/man

porg -lp+ $TARGET "\
mandb -c /opt/jdk/man" \
	1> $LOG/$TARGET.3_mandb.log 2>&1 || exit 1

porg -lp+ $TARGET "\
/usr/sbin/make-ca -g --force" \
	1> $LOG/$TARGET.4_makeca.log 2>&1 || exit 1
porg -lp+ $TARGET "\
ln -sfv /etc/ssl/java/cacerts.jks /opt/jdk/lib/security/cacerts" \
	1>> $LOG/$TARGET.4_makeca.log 2>&1 || exit 1

pushd /opt/jdk
echo Just press ENTER
porg -lp+ $TARGET "\
bin/keytool -list -cacerts" \
	1>> $LOG/$TARGET.4_makeca.log 2>&1 || exit 1
popd

TimeEnd

cd ..
RemoveSrcDir
PorgingDone
