#!/bin/sh

. ./_blfsset.sh

APPNAME=node
VER=12.18.0
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$APPNAME-v$VER.tar.xz
TARGETDIR=$APPNAME-v$VER

echo $TARGET

. $WRK/_checkRequired.sh \
	python-2 which icu
. $WRK/_checkOptions.sh  \
	c-ares libuv nghttp2 \
	http-parser npm
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

#--shared-openssl               \
Configuring
./configure --prefix=/usr                  \
            --shared-zlib                  \
            --with-intl=system-icu         \
$([ ${OPTION_httpparser} -eq 1 ] && echo --shared-http-parser) \
$([ ${OPTION_nghttp2} -eq 1 ] && echo --shared-nghttp2) \
$([ ${OPTION_cares} -eq 1 ] && echo --shared-cares) \
$([ ${OPTION_libuv} -eq 1 ] && echo --shared-libuv) \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make -j1 \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
porg -lp $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1
porg -lp+ $TARGET "\
ln -sf node /usr/share/doc/node-$VER" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PorgingDone

