#!/bin/sh

. ./_blfsset.sh

APPNAME=LSB-Tools
VER=0.6
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.gz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh ""
. $WRK/_checkOptions.sh  ""
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

echo Building...
python3 setup.py build \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
porg -lp $TARGET -E`pwd` "\
python3 setup.py install --optimize=1" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1
#porg -lp+ $TARGET "\
#ln -sv /usr/lib/lsb/install_initd /usr/sbin" \
#	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1
#porg -lp+ $TARGET "\
#ln -sv /usr/lib/lsb/remove_initd  /usr/sbin" \
#	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1
#porg -lp+ $TARGET "\
#rm -v /usr/{lsb_release.1,remove_initd.8,install_initd.8}" \
#	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1
#porg -lp+ $TARGET "\
#rm -v /usr/{INSTALL,LICENSE}" \
#	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PorgingDone

