#!/bin/sh

. ./_blfsset.sh

APPNAME=libtiff
VER=4.0.10
TARGET=libtiff-$VER
TARGETBALL=$DLD/tiff-$VER.tar.gz
TARGETDIR=tiff-$VER

echo $TARGET

. $WRK/_checkRequired.sh ""
. $WRK/_checkOptions.sh  \
	libjpeg-turbo jbigkit freeglut
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

mkdir -p libtiff-build
cd       libtiff-build

Configuring
cmake -DCMAKE_INSTALL_DOCDIR=/usr/share/doc/libtiff-$VER \
      -DCMAKE_INSTALL_PREFIX=/usr -G Ninja .. \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
ninja \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
porg -lp $TARGET 'ninja install' \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ../..
RemoveSrcDir
PorgingDone

