#!/bin/sh

. ./_blfsset.sh

APPNAME=libofa
VER=0.9.3
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.gz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	expat curl fftw
. $WRK/_checkOptions.sh  ""
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

unset MAKEFLAGS

TimeStart

cd $TARGETDIR

echo Patching from CBLFS...
patch -Np1 -i $DLD/libofa-$VER-update_to_r8438.patch \
	1> $LOG/$TARGET.0_patch.log 2>&1 || exit 1
sed -i "1i\#include <stdlib.h>" lib/signal_op.cpp
sed -i "1i\#include <stdio.h>\n#include <string.h>" examples/example.cpp
sed -i "1i\#include <string.h>" examples/protocol.cpp

Configuring
./configure --prefix=/usr \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

