#!/bin/sh

. ./_blfsset.sh

APPNAME=libgssapi
VER=0.11
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.gz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh ""
. $WRK/_checkOptions.sh  ""
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

Configuring
./configure --prefix=/usr \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

paco -p+ $TARGET "\
mv -v /usr/lib/libgssapi.so.2* /lib" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

paco -p+ $TARGET "\
ln -sfv ../../lib/libgssapi.so.2.0.0 /usr/lib/libgssapi.so" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

paco -p+ $TARGET "\
cd /usr/include && ln -sfv gssglue/gssapi gssapi" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

