#!/bin/sh

. ./_blfsset.sh

APPNAME=libcaca
VER=0.99.beta18
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.gz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh ""
. $WRK/_checkOptions.sh  \
	imlib2 Xorg-lib-libX11 openjdk ruby \
        pango cppunit zzuf slang
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

unset MAKEFLAGS

cd $TARGETDIR

# --disable-python を指定
# これがないと make install 時に
# ../.auto/py-compile: Missing argument to --destdir.
# のエラーとなる
# --disable-java を指定
#  make時にエラーとなったため
Configuring
./configure --prefix=/usr \
	--disable-python \
	--disable-java \
	$([ ${OPTION_imlib2} -ne "1" ] && echo --disable-imlib2 --disable-doc) \
	$([ ${OPTION_slang} -eq "1" ] && echo --enable-slang) \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

