#!/bin/sh

. ./_blfsset.sh

APPNAME=liba52
VER=0.7.4
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/a52dec-$VER.tar.gz
TARGETDIR=a52dec-$VER

echo $TARGET

. $WRK/_checkRequired.sh ""
. $WRK/_checkOptions.sh  ""
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

Configuring
./configure --prefix=/usr \
            --mandir=/usr/share/man \
            --enable-shared \
            --disable-static \
           CFLAGS="-g -O2 $([ $(uname -m) = x86_64 ] && echo -fPIC)" \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

cp liba52/a52_internal.h /usr/include/a52dec
install -v -m644 -D doc/liba52.txt \
    /usr/share/doc/liba52-0.7.4/liba52.txt

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

