#!/bin/sh

. ../_blfsset.sh
. ./_kdeset.sh

VER=0.99.0
TARGET=polkit-kde-agent-$VER
TARGETBALL=polkit-kde-agent-1-$VER.tar.bz2
TARGETDIR=polkit-kde-agent-1-$VER

echo Check Required...
../_checkRequired.sh polkit-qt kdelibs || exit 1

if test "$1" == "check"; then
  exit 0
fi

cd $SRC

echo $TARGET

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

cd $TARGETDIR

patch -Np1 -i $DLD/polkit-kde-agent-1-$VER-remember_password-1.patch \
	1> $LOG/$TARGET.0_patch.log 2>&1 || exit 1

mkdir build
cd build

echo \ \ Cmaking...
cmake -DCMAKE_INSTALL_PREFIX=$KDE_PREFIX .. \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

echo \ \ Making...
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

echo \ \ Installing...
paco -p $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

echo -n \ \ Pacoing:\   && paco $TARGET || echo none

echo \ \ Removing directory...
cd ../.. && rm -fr $TARGETDIR

