#!/bin/sh

. ../_blfsset.sh
. ./_kdeset.sh

VER=4.9.1
TARGET=kde-workspace-$VER
TARGETBALL=$TARGET.tar.xz
TARGETDIR=$TARGET

echo Check Required...
../_checkRequired.sh kactivities qimageblitz \
	|| exit 1

echo Check Options...
. ../_checkOptions.sh kdepimlibs boost freetype pciutils \
	consolekit Linux-PAM libusb NetworkManager lm_sensors

if test "$1" == "check"; then
  exit 0
fi

cd $SRC

echo $TARGET

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

cd $TARGETDIR

mkdir build
cd build

echo \ \ Cmaking...
cmake -DCMAKE_INSTALL_PREFIX=$KDE_PREFIX \
      -DSYSCONF_INSTALL_DIR=/etc/kde \
      -DPYTHON_SITE_PACKAGES_INSTALL_DIR=/usr/lib/python2.7/site-packages \
      .. \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

echo \ \ Making...
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

echo \ \ Installing...
paco -p $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

echo -n \ \ Pacoing:\   && paco $TARGET || echo none

echo \ \ Removing directory...
cd ../.. && rm -fr $TARGETDIR

