#!/bin/sh

. ./_blfsset.sh

TARGET=blfs-bootscripts-$BOOTSCRIPTDATE
SCRIPT=install-service-dhcpcd
TARGETBALL=$DLD/$TARGET.tar.xz
TARGETDIR=$TARGET

echo $SCRIPT

. $WRK/_checkRequired.sh dhcpcd
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

Installing
porg -lp "install-service-dhcpcd" "make install-service-dhcpcd" \
	1> $LOG/${SCRIPT}_1.install.log 2>&1 || (echo Error occured && exit 1)

porg -lp+ "install-service-dhcpcd" "\
cat > /etc/sysconfig/ifconfig.eth0 << "EOF"
ONBOOT=yes
IFACE=eth0
SERVICE=dhcpcd
DHCP_START=\"-q\"
DHCP_STOP=\"-k\"
IP_OPTIONS=\"-family inet\"

# Set PRINTIP="yes" to have the script print
# the DHCP assigned IP address
PRINTIP="no"

# Set PRINTALL="yes" to print the DHCP assigned values for
# IP, SM, DG, and 1st NS. This requires PRINTIP="yes".
PRINTALL="no"
EOF
"

TimeEnd

cd ..
RemoveSrcDir
PorgingDone $SCRIPT

