#!/bin/sh

. ./_blfsset.sh

APPNAME=gst-plugins-ugly
VER=0.10.19
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.xz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	gst-plugins-base
. $WRK/_checkOptions.sh  \
	lame libdvdnav libdvdread opencore-amr \
        liba52 libcdio libmad libmpeg2 libsidplay orc twolame \
        valgrind gtk-doc python-2
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

unset MAKEFLAGS

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

#echo Patching unofficial...
#patch -Np1 -i $WRK/patch/gst-plugins-ugly-$VER.patch \
#	1> $LOG/$TARGET.0_patch.log 2>&1 || exit 1
Patching
patch -Np1 -i $DLD/gst-plugins-ugly-$VER-libcdio_fixes-1.patch \
	1> $LOG/$TARGET.0_patch.log 2>&1 || exit 1

Configuring
AMRNB_CFLAGS='-I/usr/include/opencore-amrnb ' \
AMRWB_CFLAGS='-I/usr/include/opencore-amrwb ' \
./configure --prefix=/usr \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
AMRNB_CFLAGS='-I/usr/include/opencore-amrnb ' \
AMRWB_CFLAGS='-I/usr/include/opencore-amrwb ' \
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p  $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

