#!/bin/sh

. ./_blfsset.sh

# https://dl.google.com/go/go1.14.4.src.tar.gz

APPNAME=go
VER=1.14.4
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/${APPNAME}${VER}.src.tar.gz
TARGETDIR=$APPNAME

#Bootstrapping
BVER=1.4
BTARGETBALL=${APPNAME}${BVER}-bootstrap-20171003.tar.gz
BTARGETDIR=$APPNAME

echo $TARGET

. $WRK/_checkRequired.sh ""
. $WRK/_checkOptions.sh  ""
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir

mkdir -p go
cd go
Extract
mkdir -p go_bootstrap
cd go_bootstrap
tar xf $DLD/$BTARGETBALL

TimeStart

cd go/src

echo Bootstrapping...
./all.bash \
	1> $LOG/$TARGET.1_boot.log 2>&1

cd ../../..
cd ../go/go/src

mkdir -p /usr/lib/go

Making
porg -lp $TARGET "\
GOROOT_FINAL=/usr/lib/go \
GOROOT_BOOTSTRAP=/mnt/lfs/sources/BLFS/go/go_bootstrap/go \
./all.bash"  \
	1> $LOG/$TARGET.2_make.log 2>&1 

Installing
porg -lp+ $TARGET "\
cp ../bin/go /usr/bin" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1
porg -lp+ $TARGET "\
cp ../bin/gofmt /usr/bin" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ../../..
pwd
RemoveSrcDir
PorgingDone

