#!/bin/sh

. ../_blfsset.sh
. ./_gnomeset.sh

APPNAME=gnome-settings-daemon
VER=3.6.4
TARGET=$APPNAME-$VER
TARGETBALL=$GNOMEDLD/$TARGET.tar.xz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	colord gnome-desktop libcanberra \
        libnotify libgnomekbd libwacom pulseaudio upower \
        xf86-input-wacom ibus
. $WRK/_checkOptions.sh  \
	cups ibus nss
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

#echo \ \ Patching...
#patch -Np1 -i $GNOMEDLD/gnome-settings-daemon-$VER-cups-1.patch \
#	1> $LOG/$TARGET.0_patch.log 2>&1 || exit 1

Configuring
./configure --prefix=/usr \
            --sysconfdir=/etc \
            --libexecdir=/usr/lib/gnome-settings-daemon \
            --disable-packagekit \
            --disable-static \
$([ ${OPTION_cups} -ne 1 ] && echo --disable-cups) \
$([ ${OPTION_ibus} -ne 1 ] && echo --disable-ibus) \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

