#!/bin/sh

. ../_blfsset.sh
. ./_gnomeset.sh

APPNAME=caribou
VER=0.4.4.2
TARGET=$APPNAME-$VER
TARGETBALL=$GNOMEDLD/$TARGET.tar.xz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	pygobject gtk+-3 clutter \
        libgee libxklavier vala
. $WRK/_checkOptions.sh  \
	gobject-introspection
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

Configuring
./configure --prefix=$GNOME_PREFIX \
            --sysconfdir=$GNOME_SYSCONFDIR \
            --libexecdir=$GNOME_PREFIX/lib/caribou \
            --disable-gtk2-module \
	    --disable-static \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

