#!/bin/sh

. ../_blfsset.sh

APPNAME=pacman
VER=git
TARGET=$APPNAME-$VER
TARGETDIR=$TARGET
GITDIR=/mnt/lfs/download/git/$APPNAME

echo $TARGET

. $WRK/_checkRequired.sh ""
. $WRK/_checkOptions.sh  ""
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
rm -fr $TARGETDIR
mkdir -pv $TARGETDIR

TimeStart

cd $TARGETDIR

echo Autogen...
pushd $GITDIR
./autogen.sh \
	1> $LOG/$TARGET.0_auto.log 2>&1 || exit 1
autoreconf
	1>> $LOG/$TARGET.0_auto.log 2>&1 || exit 1
popd

Configuring
$GITDIR/configure --prefix=/usr \
	--sysconfdir=/etc \
	--disable-doc \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make -j1 \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
porg -lp $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
rm -fr $TARGETDIR
PorgingDone

