#!/bin/sh

. ./_blfsset.sh

APPNAME=genshi
VER=0.7
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/Genshi-$VER.tar.gz
TARGETDIR=Genshi-$VER

echo $TARGET

. $WRK/_checkRequired.sh \
	Python
. $WRK/_checkOptions.sh  ""
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

Installing
porg -lp $TARGET "python setup.py install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PorgingDone

