#!/bin/sh

. ./_blfsset.sh

APPNAME=fam
VER=2.7.0
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.gz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh ""
. $WRK/_checkOptions.sh  ""
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

unset MAKEFLAGS

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

echo Patching from CBLFS... 
patch -Np1 -i $DLD/fam-$VER-debian-2.patch \
	1> $LOG/$TARGET.0_patch.log 2>&1 || exit 1

echo Autotooling...
libtoolize \
	1> $LOG/$TARGET.0_auto.log 2>&1 || exit 1
aclocal \
	1> $LOG/$TARGET.0_auto.log 2>&1 || exit 1
automake --add-missing \
	1>> $LOG/$TARGET.0_auto.log 2>&1 || exit 1
autoreconf \
	1>> $LOG/$TARGET.0_auto.log 2>&1 || exit 1

sed -i -e s/NULL/0/g src/Interest.h

sed -i 's/char \* p;/const &/' src/NFSFileSystem.c++

Configuring
./configure --prefix=/usr --sysconfdir=/etc \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
porg -lp $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PorgingDone

