#!/bin/sh

. ./_blfsset.sh

APPNAME=docbook-xsl
VER=1.79.2
TARGET=$APPNAME-nons-$VER
TARGETBALL=$DLD/$TARGET.tar.bz2
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh libxml2
. $WRK/_checkOptions.sh  ""
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

Patching
patch -Np1 -i $DLD/docbook-xsl-nons-$VER-stack_fix-1.patch \
	1> $LOG/$TARGET.0_patch.log 2>&1 || exit 1

#echo \ \ Extracting doc...
#tar xf $DLD/docbook-xsl-doc-$VER.tar.bz2 --strip-components=1 \
#	 || (echo Tarball not found && exit 1)

echo Copying...
install -v -m755 -d /usr/share/xml/docbook/xsl-stylesheets-nons-$VER \
	1> $LOG/$TARGET.1_copy.log 2>&1 || exit 1

porg -lp  $TARGET "\
cp -v -R VERSION assembly common eclipse epub epub3 extensions fo        \
         highlighting html htmlhelp images javahelp lib manpages params  \
         profiling roundtrip slides template tests tools webhelp website \
         xhtml xhtml-1_1 xhtml5                                          \
    /usr/share/xml/docbook/xsl-stylesheets-nons-$VER" \
	1>> $LOG/$TARGET.1_copy.log 2>&1 || exit 1

porg -lp+ $TARGET "\
ln -s VERSION /usr/share/xml/docbook/xsl-stylesheets-nons-$VER/VERSION.xsl" \
	1>> $LOG/$TARGET.1_copy.log 2>&1 || exit 1

porg -lp+ $TARGET "\
install -v -m644 -D README \
                    /usr/share/doc/docbook-xsl-nons-$VER/README.txt" \
	1>> $LOG/$TARGET.1_copy.log 2>&1 || exit 1

porg -lp+ $TARGET "\
install -v -m755    RELEASE-NOTES* NEWS* \
                    /usr/share/doc/docbook-xsl-nons-$VER" \
	1>> $LOG/$TARGET.1_copy.log 2>&1 || exit 1

if [ ! -d /etc/xml ]; then
porg -lp+ $TARGET "\
install -v -m755 -d /etc/xml"
fi

if [ ! -f /etc/xml/catalog ]; then
porg -lp+ $TARGET "\
    xmlcatalog --noout --create /etc/xml/catalog"
fi

xmlcatalog --noout --add "rewriteSystem" \
           "http://docbook.sourceforge.net/release/xsl/$VER" \
           "/usr/share/xml/docbook/xsl-stylesheets-nons-$VER" \
    /etc/xml/catalog

xmlcatalog --noout --add "rewriteURI" \
           "http://docbook.sourceforge.net/release/xsl/$VER" \
           "/usr/share/xml/docbook/xsl-stylesheets-nons-$VER" \
    /etc/xml/catalog

xmlcatalog --noout --add "rewriteSystem" \
           "http://docbook.sourceforge.net/release/xsl/current" \
           "/usr/share/xml/docbook/xsl-stylesheets-nons-$VER" \
    /etc/xml/catalog

xmlcatalog --noout --add "rewriteURI" \
           "http://docbook.sourceforge.net/release/xsl/current" \
           "/usr/share/xml/docbook/xsl-stylesheets-nons-$VER" \
    /etc/xml/catalog

TimeEnd

cd ..
RemoveSrcDir
PorgingDone

