#!/bin/sh

. ./_blfsset.sh

APPNAME=docbook-utils
VER=0.6.14
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.gz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	openjade docbook-dsssl docbook-sgml-dtd
. $WRK/_checkOptions.sh  ""
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

Patching
patch -Np1 -i $DLD/docbook-utils-$VER-grep_fix-1.patch \
	1> $LOG/$TARGET.0_patch.log 2>&1 || exit 1

sed -i 's:/html::' doc/HTML/Makefile.in

Configuring
./configure --prefix=/usr \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p  $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

for doctype in html ps dvi man pdf rtf tex texi txt
do
    paco -p+ $TARGET "ln -s docbook2$doctype /usr/bin/db2$doctype"
done

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

