#!/bin/sh

. ./_blfsset.sh

APPNAME=dhcpcd
VER=9.2.0
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.xz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh ""
. $WRK/_checkOptions.sh  ""
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

install  -v -m700 -d /var/lib/dhcpcd &&

groupadd -g 52 dhcpcd        &&
useradd  -c 'dhcpcd PrivSep' \
         -d /var/lib/dhcpcd  \
         -g dhcpcd           \
         -s /bin/false     \
         -u 52 dhcpcd &&
chown    -v dhcpcd:dhcpcd /var/lib/dhcpcd 

cd $TARGETDIR

Configuring
./configure --libexecdir=/lib/dhcpcd \
            --dbdir=/var/lib/dhcpcd  \
            --privsepuser=dhcpcd     \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
porg -lp $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PorgingDone
