#!/bin/sh

. ./_blfsset.sh

APPNAME=cmake
VER=3.18.4
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.gz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	libuv curl libarchive
. $WRK/_checkOptions.sh  \
	subversion qt-5 sphinx
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

sed -i '/"lib64"/s/64//' Modules/GNUInstallDirs.cmake

echo Bootstrapping...
./bootstrap --prefix=/usr \
            --system-libs \
            --mandir=/share/man \
            --no-system-jsoncpp \
            --no-system-librhash \
            --docdir=/share/doc/cmake-$VER \
            $([ ${OPTION_qt5} -eq 1 ] && echo --qt-gui) \
	1> $LOG/$TARGET.1_boot.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

PWD=`pwd`
Installing
porg -lp  $TARGET -E/tmp:$PWD "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PorgingDone
