#!/bin/sh

. ./_blfsset.sh

APPNAME=bluez
VER=5.24
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.xz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	dbus glib-2 libical
. $WRK/_checkOptions.sh  ""
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

Patching
patch -Np1 -i $DLD/bluez-$VER-obexd_without_systemd-1.patch \
	1> $LOG/$TARGET.0_patch.log 2>&1 || exit 1

Configuring
CONF_OPTIONS="\
            --prefix=/usr         \
            --sysconfdir=/etc     \
            --localstatedir=/var  \
            --enable-library      \
            --disable-systemd"

#CONF_OPTIONS+="\
#$([ "${OPTION_alsalib}" -eq 1 ] && echo --enable-alsa) \
#$([ "${OPTION_gstpluginsbase0}" -eq 1 ] && echo --enable-gstreamer) \
#$([ "${OPTION_libusbcompat}" -eq 1 ] && echo --enable-usb ) \
#"

echo $CONF_OPTIONS \
	> $LOG/$TARGET.1_conf.log

./configure $CONF_OPTIONS \
	1>> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
porg -lp $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

porg -lp+ $TARGET "\
ln -svf ../libexec/bluetooth/bluetoothd /usr/sbin" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PorgingDone

