#!/bin/sh

. ./_blfsset.sh

APPNAME=alsa-tools
VER=1.0.27
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.bz2
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	alsa-lib
. $WRK/_checkOptions.sh  \
	gtk+-2 gtk+-3 fltk
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

unset MAKEFLAGS

cd $SRC
RemoveSrcDir
Extract

cd $TARGETDIR

TimeStart

for package in `ls`; do

if test -d $package; then

echo -e "\e[32;1m$package\e[m..."
cd $package

Configuring
./configure --prefix=/usr \
	1> $LOG/$APPNAME-$package-$VER.1_conf.log 2>&1 || \
	(cd .. && continue)

Making
make \
	1> $LOG/$APPNAME-$package-$VER.2_make.log 2>&1 || \
	(cd .. && continue)

Installing
paco -p $APPNAME-$package-$VER "make install" \
	1> $LOG/$APPNAME-$package-$VER.3_install.log 2>&1 || \
	(cd .. && continue)

cd ..

fi

done

TimeEnd

cd ..
rm -fr $APPNAME-$VER
PacoingDone

