#!/bin/sh

. ./_blfsset.sh

APPNAME=acpid
VER=2.0.27
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.xz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh ""
. $WRK/_checkOptions.sh  ""
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

Configuring
./configure --prefix=/usr \
	--docdir=/usr/share/doc/acpid-$VER \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
porg -lp $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

install -m755 -d /etc/acpi/events
porg -lp+ $TARGET "\
cp -r samples /usr/share/doc/acpid-$VER" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

cat > /etc/acpi/events/lid << "EOF"
event=button/lid
action=/etc/acpi/lid.sh
EOF
porg -lp+ $TARGET "\
touch /etc/acpi/events/lid" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

cat > /etc/acpi/lid.sh << "EOF"
#!/bin/sh
/bin/grep -q open /proc/acpi/button/lid/LID/state && exit 0
/usr/sbin/pm-suspend
EOF
porg -lp+ $TARGET "\
touch /etc/acpi/lid.sh" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

chmod +x /etc/acpi/lid.sh

TimeEnd

cd ..
RemoveSrcDir
PorgingDone
