#!/bin/sh

. ./_blfsset.sh

APPNAME=acl
VER=2.2.52
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/${TARGET}.src.tar.gz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh attr
. $WRK/_checkOptions.sh  ""
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

sed -i -e 's|/@pkg_name@|&-@pkg_version@|' \
     include/builddefs.in

Configuring
INSTALL_USER=root  \
INSTALL_GROUP=root \
./configure --prefix=/usr --libexecdir=/usr/lib \
        --disable-static \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p $TARGET "\
make install install-dev install-lib" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

chmod -v 755 /usr/lib/libacl.so \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

paco -p+ $TARGET "\
mv -v /usr/lib/libacl.so.* /lib" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

paco -p+ $TARGET "\
ln -sfv ../../lib/libacl.so.1 /usr/lib/libacl.so"
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

paco -p+ $TARGET "\
install -v -m644 doc/*.txt /usr/share/doc/acl-$VER" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

