#!/bin/sh

function teckit() {
cd libs
cd teckit

SUBPKG=teckit

echo $SUBPKG: Configuring...
../configure --prefix=$INSTDIR \
	--with-system-zlib \
        1> $LOG/$TARGET-$SUBPKG.1_conf.log 2>&1 || exit 1

echo $SUBPKG: Making...
make \
        1> $LOG/$TARGET-$SUBPKG.2_make.log 2>&1 || exit 1

echo $SUBPKG: Installing...
porg -lp $TARGET "make install" \
        1> $LOG/$TARGET-$SUBPKG.3_install.log 2>&1 || exit 1

cd ../..
}

function lua52() {
cd libs
cd lua52

SUBPKG=lua52

echo $SUBPKG: Configuring...
../configure --prefix=$INSTDIR \
        1> $LOG/$TARGET-$SUBPKG.1_conf.log 2>&1 || exit 1

echo $SUBPKG: Making...
make \
        1> $LOG/$TARGET-$SUBPKG.2_make.log 2>&1 || exit 1

echo $SUBPKG: Installing...
porg -lp+ $TARGET "make install" \
        1> $LOG/$TARGET-$SUBPKG.3_install.log 2>&1 || exit 1

cd ../..
}

function luajit() {
cd libs
cd luajit

SUBPKG=luajit

echo $SUBPKG: Configuring...
../configure --prefix=$INSTDIR \
        1> $LOG/$TARGET-$SUBPKG.1_conf.log 2>&1 || exit 1

echo $SUBPKG: Making...
make \
        1> $LOG/$TARGET-$SUBPKG.2_make.log 2>&1 || exit 1

echo $SUBPKG: Installing...
porg -lp+ $TARGET "make install" \
        1> $LOG/$TARGET-$SUBPKG.3_install.log 2>&1 || exit 1

cd ../..
}

function graphite2() {
cd libs
cd graphite2

SUBPKG=graphite2

echo $SUBPKG: Configuring...
../configure --prefix=$INSTDIR \
        1> $LOG/$TARGET-$SUBPKG.1_conf.log 2>&1 || exit 1

echo $SUBPKG: Making...
make \
        1> $LOG/$TARGET-$SUBPKG.2_make.log 2>&1 || exit 1

echo $SUBPKG: Installing...
porg -lp+ $TARGET "make install" \
        1> $LOG/$TARGET-$SUBPKG.3_install.log 2>&1 || exit 1

cd ../..
}

function xpdf() {
cd libs
cd xpdf

SUBPKG=xpdf

echo $SUBPKG: Configuring...
../configure --prefix=$INSTDIR \
        1> $LOG/$TARGET-$SUBPKG.1_conf.log 2>&1 || exit 1

echo $SUBPKG: Making...
make \
        1> $LOG/$TARGET-$SUBPKG.2_make.log 2>&1 || exit 1

echo $SUBPKG: Installing...
porg -lp+ $TARGET "make install" \
        1> $LOG/$TARGET-$SUBPKG.3_install.log 2>&1 || exit 1

cd ../..
}

function kpathsea() {
cd texk
cd kpathsea

SUBPKG=kpathsea

echo $SUBPKG: Configuring...
../configure --prefix=$INSTDIR \
        1> $LOG/$TARGET-$SUBPKG.1_conf.log 2>&1 || exit 1

echo $SUBPKG: Making...
make \
        1> $LOG/$TARGET-$SUBPKG.2_make.log 2>&1 || exit 1

echo $SUBPKG: Installing...
porg -lp+ $TARGET "make install" \
        1> $LOG/$TARGET-$SUBPKG.3_install.log 2>&1 || exit 1

cd ../..
}

function ptexenc() {
cd texk
cd ptexenc

SUBPKG=ptexenc

echo $SUBPKG: Configuring...
../configure --prefix=$INSTDIR \
        1> $LOG/$TARGET-$SUBPKG.1_conf.log 2>&1 || exit 1

echo $SUBPKG: Making...
make \
        1> $LOG/$TARGET-$SUBPKG.2_make.log 2>&1 || exit 1

echo $SUBPKG: Installing...
porg -lp+ $TARGET "make install" \
        1> $LOG/$TARGET-$SUBPKG.3_install.log 2>&1 || exit 1

cd ../..
}

function zziplib() {
cd libs
cd zziplib

SUBPKG=zziplib

echo $SUBPKG: Configuring...
../configure \
	--prefix=$INSTDIR \
	--with-system-zlib \
        1> $LOG/$TARGET-$SUBPKG.1_conf.log 2>&1 || exit 1

echo $SUBPKG: Making...
make \
        1> $LOG/$TARGET-$SUBPKG.2_make.log 2>&1 || exit 1

echo $SUBPKG: Installing...
porg -lp+ $TARGET "make install" \
        1> $LOG/$TARGET-$SUBPKG.3_install.log 2>&1 || exit 1

cd ../..
}

function web2c() {
cd texk
cd web2c

SUBPKG=web2c

       # --disable-xetex \
       # --with-system-t1lib \
       # --with-system-gd \
echo $SUBPKG: Configuring...
../configure                                        \
    --prefix=$INSTDIR                               \
    --bindir=/opt/texlive/2016/bin/$TEXARCH         \
    --datarootdir=/opt/texlive/2016                 \
    --includedir=/opt/texlive/2016/include          \
    --infodir=/opt/texlive/2016/texmf-dist/doc/info \
    --libdir=/opt/texlive/2016/lib                  \
    --mandir=/opt/texlive/2016/texmf-dist/doc/man   \
    --disable-native-texlive-build                  \
    --disable-static --enable-shared                \
    --with-system-cairo                             \
    --with-system-fontconfig                        \
    --with-system-freetype2                         \
    --with-system-gmp                               \
    --with-system-graphite2                         \
    --with-system-harfbuzz                          \
    --with-system-icu                               \
    --with-system-libgs                             \
    --with-system-libpaper                          \
    --with-system-libpng                            \
    --with-system-mpfr                              \
    --with-system-pixman                            \
    --with-system-poppler                           \
    --with-system-xpdf                              \
    --with-system-zlib                              \
    --with-banner-add=" - BLFS"                     \
    --without-x                                     \
    --disable-aleph                                 \
    --disable-chktex                                \
    --disable-detex                                 \
    --disable-devnag                                \
    --disable-dtl                                   \
    --disable-dvi2tty                               \
    --disable-dvidvi                                \
    --disable-dviljk                                \
    --disable-dvipng                                \
    --disable-dvipos                                \
    --disable-dvisvgm                               \
    --disable-lacheck                               \
    --disable-synctex                               \
        1> $LOG/$TARGET-$SUBPKG.1_conf.log 2>&1 || exit 1

echo $SUBPKG: Making...
make \
        1> $LOG/$TARGET-$SUBPKG.2_make.log 2>&1 || exit 1

echo $SUBPKG: Installing...
porg -lp+ $TARGET "make install" \
        1> $LOG/$TARGET-$SUBPKG.3_install.log 2>&1 || exit 1

cd ../..
}

function dvipdfmx() {
cd texk
cd dvipdfm-x

SUBPKG=dvipdfm-x

echo $SUBPKG: Configuring...
../configure --prefix=$INSTDIR \
        --with-system-zlib \
        --with-system-libpng \
        --with-system-libpaper \
        1> $LOG/$TARGET-$SUBPKG.1_conf.log 2>&1 || exit 1

echo $SUBPKG: Making...
make \
        1> $LOG/$TARGET-$SUBPKG.2_make.log 2>&1 || exit 1

echo $SUBPKG: Installing...
porg -lp+ $TARGET "make install" \
        1> $LOG/$TARGET-$SUBPKG.3_install.log 2>&1 || exit 1

cd ../..
}

function dvipsk() {
cd texk
cd dvipsk

SUBPKG=dvipsk

echo $SUBPKG: Configuring...
../configure --prefix=$INSTDIR \
        1> $LOG/$TARGET-$SUBPKG.1_conf.log 2>&1 || exit 1

echo $SUBPKG: Making...
make \
        1> $LOG/$TARGET-$SUBPKG.2_make.log 2>&1 || exit 1

echo $SUBPKG: Installing...
porg -lp+ $TARGET "make install" \
        1> $LOG/$TARGET-$SUBPKG.3_install.log 2>&1 || exit 1

cd ../..
}

function texlive() {
cd texk
cd texlive

SUBPKG=texlive

echo $SUBPKG: Configuring...
../configure --prefix=$INSTDIR \
        1> $LOG/$TARGET-$SUBPKG.1_conf.log 2>&1 || exit 1

echo $SUBPKG: Making...
make \
        1> $LOG/$TARGET-$SUBPKG.2_make.log 2>&1 || exit 1

echo $SUBPKG: Installing...
porg -lp+ $TARGET "make install" \
        1> $LOG/$TARGET-$SUBPKG.3_install.log 2>&1 || exit 1

cd ../..
}

