#!/bin/sh

. ../_blfsset.sh
. ./_xorgset.sh

APPNAME=cairo
VER=1.14.12
TARGET=$APPNAME-$VER
TARGETBALL=$XORGDLD/$TARGET.tar.xz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	libpng glib-2 pixman
. $WRK/_checkOptions.sh  \
	fontconfig Xorg-lib-libX11 \
	cogl directfb libdrm gtk-doc mesalib \
	qt-4 skia valgrind xcb-util
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

if [ ${OPTION_xcbutil} -eq "1" ]; then
  export ENABLEXCB="--enable-xcb=yes "
else
  export ENABLEXCB=""
fi

if [ ${OPTION_XorgliblibX11} -eq "1" ]; then
  export WITHX="--with-x "
else
  export WITHX="--without-x "
fi

unset MAKEFLAGS

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

Configuring
#	$([ ${OPTION_libdrm} -eq "1" ] && echo --enable-drm) \
#	$([ ${OPTION_cogl} -eq "1" ] && echo --enable-cogl) \
./configure --prefix=/usr \
            --disable-static \
	    --enable-tee \
            $ENABLEXCB \
	    $WITHX \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
porg -lp $TARGET -E`pwd` "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PorgingDone

