#!/bin/sh

. ./_blfsset.sh

APPNAME=Linux-PAM
VER=1.3.0
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.bz2
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh ""
. $WRK/_checkOptions.sh  \
	db cracklib libtirpc libprelude
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

if [ ${OPTION_libtirpc} -eq "1" ]; then
  export DISABLENIS=""
else
  export DISABLENIS="--disable-nis "
fi

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

Configuring
./configure --prefix=/usr                    \
	    --sysconfdir=/etc                \
            --libdir=/usr/lib                \
	    --disable-regenerate-docu        \
            --enable-securedir=/lib/security \
            --docdir=/usr/share/doc/Linux-PAM-$VER \
            $DISABLENIS \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
porg -lp  $TARGET -E`pwd` "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

chmod -v 4755 /sbin/unix_chkpwd \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

for file in pam pam_misc pamc
do
  porg -lp+ $TARGET "\
  mv -v /usr/lib/lib${file}.so.* /lib" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

  porg -lp+ $TARGET "\
  ln -sfv ../../lib/$(readlink /usr/lib/lib${file}.so) /usr/lib/lib${file}.so" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1
done

install -v -m755 -d /etc/pam.d

cat > /etc/pam.d/other << "EOF"
# Begin /etc/pam.d/other

auth        required        pam_warn.so
auth        required        pam_deny.so
account     required        pam_warn.so
account     required        pam_deny.so
password    required        pam_warn.so
password    required        pam_deny.so
session     required        pam_warn.so
session     required        pam_deny.so

# End /etc/pam.d/other
EOF
porg -lp+ $TARGET "touch /etc/pam.d/other"

cat > /etc/pam.d/system-account << "EOF"
# Begin /etc/pam.d/system-account

account   required    pam_unix.so

# End /etc/pam.d/system-account
EOF
porg -lp+ $TARGET "touch /etc/pam.d/system-account"

cat > /etc/pam.d/system-auth << "EOF"
# Begin /etc/pam.d/system-auth

auth      required    pam_unix.so

# End /etc/pam.d/system-auth
EOF
porg -lp+ $TARGET "touch /etc/pam.d/system-auth"

cat > /etc/pam.d/system-session << "EOF"
# Begin /etc/pam.d/system-session

session   required    pam_unix.so

# End /etc/pam.d/system-session
EOF
porg -lp+ $TARGET "touch /etc/pam.d/system-session"

if [ ${OPTION_cracklib} -eq "1" ]; then
cat > /etc/pam.d/system-password << "EOF"
# Begin /etc/pam.d/system-password

# check new passwords for strength (man pam_cracklib)
password  required    pam_cracklib.so   type=Linux retry=3 difok=5 \
                                        difignore=23 minlen=9 dcredit=1 \
                                        ucredit=1 lcredit=1 ocredit=1 \
                                        dictpath=/lib/cracklib/pw_dict
# use sha512 hash for encryption, use shadow, and use the
# authentication token (chosen password) set by pam_cracklib
# above (or any previous modules)
password  required    pam_unix.so       sha512 shadow use_authtok

# End /etc/pam.d/system-password
EOF
else
cat > /etc/pam.d/system-password << "EOF"
# Begin /etc/pam.d/system-password

# use sha512 hash for encryption, use shadow, and try to use any previously
# defined authentication token (chosen password) set by any prior module
password  required    pam_unix.so       sha512 shadow try_first_pass

# End /etc/pam.d/system-password
EOF
fi
porg -lp+ $TARGET "touch /etc/pam.d/system-password"

TimeEnd

cd ..
RemoveSrcDir
PorgingDone

