//
//  NextThreadFinder.m
//  NextThreadFinder
//
//  Created by Hori,Masaki on 11/02/17.
//  Copyright 2011 masakih. All rights reserved.
//

#import "NextThreadFinder.h"

@interface NSObject(BatyScapheAPIs)
- (id)threadAttributes;
- (NSString *)threadTitle;
- (NSString *)boardName;

- (void)setSearchString:(NSString *)string;

// CMRBrowser
- (void)synchronizeWithSearchField;
- (void)showThreadsListWithBoardName:(NSString *)boardName;
- (void)selectRowOfName:(NSString *)boardName forceReload:(BOOL)flag;
@end

@interface NextThreadFinder (HMPrivate)
const NSInteger kScriptMenuTag = 8;
- (void)setupMenu;
@end


@implementation NextThreadFinder
- (id)initWithPreferences:(AppDefaults *)prefs
{
	self = [super init];
	[self setupMenu];
	[NSApp setNextResponder:self];
	
	return self;
}
- (BOOL)previewLink:(NSURL *)url { return NO; }
- (BOOL)validateLink:(NSURL *)url { return NO; }
- (void)setPreferences:(AppDefaults *)aPreferences {}
- (AppDefaults *)preferences { return nil; }
- (BOOL)showImageWithURL:(NSURL *)imageURL { return NO; }

- (void)setupMenu
{
	NSMenuItem *serachMenuItem;
	NSMenu *mainMenu;
	NSInteger scriptMenuIndex;
	
	NSString *itemTitle = NSLocalizedStringFromTableInBundle(@"Search Next Thread",
															 nil,
															 [NSBundle bundleForClass:[self class]],
															 @"Menu title");
																					   
	serachMenuItem = [[[NSMenuItem alloc] initWithTitle:itemTitle
											  action:@selector(findNextThread:)
									   keyEquivalent:@""] autorelease];
	
	mainMenu = [NSApp mainMenu];
	scriptMenuIndex = [mainMenu indexOfItemWithTag:kScriptMenuTag];
	NSMenuItem *windowMenuItem = [mainMenu itemAtIndex:scriptMenuIndex - 1];
	NSMenu *windowMenu = [windowMenuItem submenu];
	
	NSInteger separatorNum = 0;
	for(NSMenuItem *item in [windowMenu itemArray]) {
		if([item isSeparatorItem]) {
			separatorNum++;
		}
		if(separatorNum == 2) {
			NSUInteger index = [windowMenu indexOfItem:item];
			[windowMenu insertItem:serachMenuItem atIndex:index + 1];
			break;
		}
	}
}

- (BOOL)validateMenuItem:(NSMenuItem *)menuItem
{
	SEL action = [menuItem action];
	if(action != @selector(findNextThread:)) return NO;
	
	if([[[[NSDocumentController sharedDocumentController] currentDocument] threadAttributes] threadTitle]) return YES;
	return NO;
}

- (id)findCMRBrowser
{
	for(NSWindow *window in [NSApp windows]) {
		NSWindowController *wc = [window windowController];
		if([wc isMemberOfClass:NSClassFromString(@"CMRBrowser")]) {
			return wc;
		}
	}
	return nil;
}
- (NSArray *)tokensForTitle:(NSString *)title
{
	NSMutableArray *tokens = [NSMutableArray array];
	
	CFLocaleRef locale = CFLocaleCreate(kCFAllocatorDefault, (CFStringRef)@"ja");
	CFStringTokenizerRef tokenizer = CFStringTokenizerCreate(kCFAllocatorDefault,
															 (CFStringRef)title,
															 CFRangeMake(0, [title length]),
															 kCFStringTokenizerUnitWordBoundary,
															 locale);
	while(CFStringTokenizerAdvanceToNextToken(tokenizer) != kCFStringTokenizerTokenNone) {
		CFRange range = CFStringTokenizerGetCurrentTokenRange(tokenizer);
		if(range.location != kCFNotFound) {
			NSString *token = [title substringWithRange:NSMakeRange(range.location, range.length)];
//			fprintf(stderr, "\t%s\n", [token UTF8String]);
			[tokens addObject:token];
		}
	}
	
	CFRelease(tokenizer);
	CFRelease(locale);
	
	return tokens;
	
}

- (NSString *)searchStringWithTitle:(NSString *)title
{
	NSArray *tokens = [self tokensForTitle:title];
	
	NSCharacterSet *numSet = [NSCharacterSet decimalDigitCharacterSet];
	NSMutableArray *array = [NSMutableArray array];
	for(NSString *token in tokens) {
		if([token length] < 3) continue;
		if([numSet characterIsMember:[token characterAtIndex:0]]) continue;
		if([numSet characterIsMember:[token characterAtIndex:[token length] - 1]]) continue;
		[array addObject:token];
	}
	return [array componentsJoinedByString:@" "];
}
- (IBAction)findNextThread:(id)sender
{
//	NSWindow *mainWindow = [NSApp mainWindow];
//	Class browserClass = NSClassFromString(@"CMRBrowser");
//	Class threadViewerClass = NSClassFromString(@"CMRThreadViewer");
//	Class threadDocumentClass = NSClassFromString(@"CMRThreadDocument");
//	Class browserDocClass = NSClassFromString(@"Browser");
	
//	NSLog(@"main Window is %@", [mainWindow windowController]);
	NSDocumentController *dc = [NSDocumentController sharedDocumentController];
//	NSLog(@"current Document is %@ <%@>", [dc currentDocument], [[dc currentDocument] displayName]);
	
//	NSLog(@"obj responds threadAttributes --- %@", [[dc currentDocument] respondsToSelector:@selector(threadAttributes)] ? @"YES" : @"NO");
//	NSLog(@"Thread title --- %@", [[[dc currentDocument] threadAttributes] threadTitle]);
	
	
	id cmrBrowser = [self findCMRBrowser];
	id browser = [cmrBrowser document];
//	NSLog(@"Browser is %@", browser);
	id threadAttributes = [[dc currentDocument] threadAttributes];
	[cmrBrowser showThreadsListWithBoardName:[threadAttributes boardName]];
	[cmrBrowser selectRowOfName:[threadAttributes boardName] forceReload:NO];
	[browser setSearchString:[self searchStringWithTitle:[threadAttributes threadTitle]]];
	[cmrBrowser synchronizeWithSearchField];
	[cmrBrowser showWindow:nil];
	
}
@end
