//
//  KMLogWindowController.m
//  BathyScaphe
//
//  Created by 堀 昌樹 on 11/12/14.
//  Copyright (c) 2011年 __MyCompanyName__. All rights reserved.
//

#import "KMLogWindowController.h"
#import "KMBSLogViewController.h"
#import "KMStatusLineViewController.h"
#import "AppDefaults.h"


@interface KMLogWindowController()
@property (nonatomic, retain) KMBSLogViewController *logViewController;
@property (nonatomic, retain) KMStatusLineViewController *statusLineController;
@end

@implementation KMLogWindowController

@synthesize logViewPlaceholder = _logViewPlaceholder;
@synthesize logViewController = _logViewController;
@synthesize statusLineViewPlaceholder = _statusLineViewPlaceholder;
@synthesize statusLineController = _statusLineController;

- (id)init
{
    self = [super initWithWindowNibName:@"KMLogWindow"];
	if(self) {
		[self window];
	}
    
    return self;
}
- (void)dealloc
{
	[[NSNotificationCenter defaultCenter] removeObserver:self
													name:KMDocumentDidChangeNotification
												  object:nil];
	
	[_logViewController release];
	_statusLineController.windowController = nil;
	[_statusLineController release];
	
	[super dealloc];
}
- (void)windowDidLoad
{
    [super windowDidLoad];
	
	[self.window setContentBorderThickness:22 forEdge:NSMinYEdge];
    
	_logViewController = [[KMBSLogViewController alloc] init];
	[self replaceAndFit:self.logViewController.view with:self.logViewPlaceholder];
	self.logViewPlaceholder = nil;
	
	_statusLineController = [[KMStatusLineViewController alloc] init];
	[self replaceAndFit:[_statusLineController view] with:_statusLineViewPlaceholder];
	self.statusLineViewPlaceholder = nil;
	self.statusLineController.windowController = self;
	
	self.logViewController.statusLine = self.statusLineController;
	[self.statusLineController validateIdxNavLazily:self.logViewController];
	
	[self.window makeFirstResponder:self.logViewController.view];
}
- (void)setDocument:(NSDocument *)document
{
	[super setDocument:document];
	if(!document) [self close];
}
- (void)restoreDocumentViewAttributes
{
	if(!self.doc) return;
	NSRect frame = self.doc.savedWindowFrame;
	if(!NSEqualRects(NSZeroRect, frame)) {
		[self.window setFrame:frame display:NO];
	}
}
- (void)saveDocumentViewAttributes
{
	NSWindow *window = self.window;
	if(window) {
		NSRect frame = [window frame];
		self.doc.savedWindowFrame = frame;
	}
}
@end
