//
//  KMAppDelegate.m
//  BathyScaphe
//
//  Created by 堀 昌樹 on 12/05/05.
//  Copyright (c) 2012年 __MyCompanyName__. All rights reserved.
//

#import "KMAppDelegate.h"

#import "KMLogDocumentWindowController.h"
#import "KMBrowser.h"


@implementation KMAppDelegate
@synthesize mainWindowController = _mainWindowController;

- (id)init
{
	self = [super init];
	if(self) {
		_mainWindowController = [[NSObjectController alloc] initWithContent:nil];
		
		NSNotificationCenter *nc = [NSNotificationCenter defaultCenter];
		[nc addObserver:self
			   selector:@selector(windowDidBecomeMain:)
				   name:NSWindowDidBecomeMainNotification
				 object:nil];
		[nc addObserver:self
			   selector:@selector(windowDidResignMainOrWillClose:)
				   name:NSWindowDidResignMainNotification
				 object:nil];
		[nc addObserver:self
			   selector:@selector(windowDidResignMainOrWillClose:)
				   name:NSWindowWillCloseNotification
				 object:nil];
		
	}
	return self;
}

- (void)dealloc
{
	[_mainWindowController release];
	
	[super dealloc];
}

- (BOOL)applicationOpenUntitledFile:(NSApplication *)sender
{
    [[[[KMBrowser alloc] init] autorelease] showWindow:nil];
	return YES;
}

- (void)windowDidBecomeMain:(NSNotification *)notification
{
	id wc = [[notification object] windowController];
	if(![wc isKindOfClass:[KMLogDocumentWindowController class]]) return;
	if([wc isEqual:[_mainWindowController content]]) return;
	
	[_mainWindowController setContent:wc];
}
- (void)windowDidResignMainOrWillClose:(NSNotification *)notification
{
	id currentMainWC = [_mainWindowController content];
	NSWindowController *wc = [[notification object] windowController];
	if(![wc isEqual:currentMainWC]) return;
	
	for(NSWindow *window in [NSApp windows]) {
		NSWindowController *newWc = [window windowController];
		if([newWc isKindOfClass:[KMLogDocumentWindowController class]]
		   && ![newWc isEqual:currentMainWC]) {
			[_mainWindowController setContent:newWc];
			return;
		}
	}
	[_mainWindowController setContent:nil];
}
@end


#import "BSThreadInfoPanelController.h"

@implementation KMAppDelegate (KMActions)

- (IBAction)showDocumentInfo:(id)sender
{
    [[BSThreadInfoPanelController sharedInstance] showWindow:sender];
}

@end
