//
//  KMLogViewRangeTest.m
//  BathyScaphe
//
//  Created by 堀 昌樹 on 12/04/16.
//  Copyright (c) 2012年 __MyCompanyName__. All rights reserved.
//

#import "KMLogViewRangeTest.h"

#import "KMBSLogViewController.h"


@interface KMBSLogViewController(KMLogViewRangeTest___)
@property (nonatomic, retain) NSTextStorage *privateTextStorage;
- (NSRange)rangeAtMessageIndex:(NSUInteger)anIndex;

@end

#if __LP64__
@implementation KMLogViewRangeTest
{
	NSMutableArray *numArray;
}
NSArray *colorArray = nil;
NSInteger colorNum = 5;

@synthesize controller = _controller;

+ (void)initialize
{
	colorArray = [NSArray arrayWithObjects:
				  [NSColor blackColor],
				  [NSColor blueColor],
				  [NSColor orangeColor],
				  [NSColor redColor],
				  [NSColor yellowColor],
				  nil];
	[colorArray retain];
}

- (void)buildNumArray
{
	NSInteger num = [self.controller numberOfMessage];
	
	[numArray release];
	numArray = [[NSMutableArray alloc] initWithCapacity:num];
	
	while([numArray count] != num) {
		NSInteger i = random() % num;
		NSNumber *val = [NSNumber numberWithInteger:i];
		if(![numArray containsObject:val]) {
			[numArray addObject:val];
		}
	}
}
-(void)run
{
	[self buildNumArray];
	NSTextStorage *storage = self.controller.privateTextStorage;
	
	[storage beginEditing];
	@try {
		NSInteger i = 0;
		for(id num in numArray) {
			NSRange range = [self.controller rangeAtMessageIndex:[num integerValue]];
			NSDictionary *attr = [NSDictionary dictionaryWithObjectsAndKeys:
								  [colorArray objectAtIndex:i++%colorNum], NSBackgroundColorAttributeName,
								  nil];
			[storage addAttributes:attr range:range];
		}
	}
	@catch (id ex) {
		//
	}
	[storage endEditing];
	
	NSRange range;
	for(NSInteger i = 0; i < [self.controller numberOfMessage]; i++) {
		range = [self.controller rangeAtMessageIndex:i];
		fprintf(stderr, "%lu - %lu\n", range.location, NSMaxRange(range));
	}
}
@end

@implementation KMBSLogViewController(KMLogViewRangeTest)
extern NSString *CMRMessageIndexAttributeName;
- (IBAction)test01:(id)sender
{
	KMLogViewRangeTest *test = [[KMLogViewRangeTest alloc] init];
	test.controller = self;
	[test run];
}

@end

#endif // __LP64__
