//
//  KMThreadList.h
//  BathyScaphe
//
//  Created by Hori,Masaki on 11/07/18.
//  Copyright 2011 masakih. All rights reserved.
//

#import "KMResponsiveViewController.h"


@class BSDBThreadList;
@class ThreadsListTable;
@interface KMThreadList : KMResponsiveViewController
{
	BSDBThreadList *_datasource;
	id worker;
	
#if !__LP64__
	NSMenu *_menu;
	ThreadsListTable *_threadListView;
	id _selection;
	
	CMRAutoscrollCondition _keepConditionForScrolling;
	NSArray *_keepSelectedThreadPathForScrolling;
#endif
}
@property (assign) IBOutlet NSMenu *menu;
@property (assign) IBOutlet ThreadsListTable *threadListView;

@property (retain) id selection;

@property (assign) NSString *filterString;
@property (assign) BSThreadsListViewModeType viewMode;

@property (readonly) NSString *boardName;
@property (readonly) NSUInteger numberOfFilteredThreads;


- (void)selectThreadWithAttributes:(NSArray *)attrs scrollToVisible:(BOOL)scroll;

@end

@interface KMThreadList(Actions)
- (IBAction)chooseColumn:(id)sender;

- (IBAction)reloadThreadsList:(id)sender;
- (IBAction)showSelectedThread:(id)sender;
- (IBAction)selectThread:(id)sender;
- (IBAction)listViewAction:(id)sender;
- (IBAction)listViewDoubleAction:(id)sender;

- (IBAction)tableViewActionDispatch:(id)sender actionKey:(NSString *)aKey defaultAction:(SEL)defaultAction;
@end

extern NSString *KMThreadListDidUpdateNotification;

