//
//  KMLogView.h
//  KMLogView
//
//  Created by 堀 昌樹 on 12/05/08.
//  Copyright (c) 2012年 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@protocol KMLogViewDelegate;
@protocol KMLogViewDatasource;

@interface KMLogView : NSTextView

@property (assign) id<KMLogViewDelegate> delegate;
@property (assign) id<KMLogViewDatasource> datasource;

- (void)reloadData;

- (NSInteger)numberOfRow;
- (NSRange)rangeOfRow:(NSUInteger)row;

- (NSInteger)clickedRow;

- (NSRect)rectOfRow:(NSInteger)row;
- (NSRange)rowsInRect:(NSRect)rect;
- (NSInteger)rowAtPoint:(NSPoint)point;


- (void)scrollRowToVisible:(NSInteger)row;

@end

@protocol KMLogViewDelegate <NSObject>
@optional
- (NSMenu *)logView:(KMLogView *)logView menuForRow:(NSInteger)row;

@end

@protocol KMLogViewDatasource <NSObject>
@optional
- (NSInteger)numberOfRowsInLogView:(KMLogView *)logView;

- (NSAttributedString *)logView:(KMLogView *)logView attributedStringForRow:(NSInteger)row;

@end
