//
//  HMDocument.m
//  testAVFoundation
//
//  Created by 堀 昌樹 on 12/06/07.
//  Copyright (c) 2012年 __MyCompanyName__. All rights reserved.
//

#import "HMDocument.h"

#import <AVFoundation/AVFoundation.h>

@interface HMDocument ()
{
	CGFloat accessoryHeight;
}
@property (retain, nonatomic) AVURLAsset *asset;
@property (retain, nonatomic) AVPlayerItem *item;
@property (retain, nonatomic) AVPlayer *player;

@end

@implementation HMDocument
@synthesize view = _view;
@synthesize playButton = _playButton;
@synthesize timeGage = _timeGage;
@synthesize timeBar = _timeBar;
@synthesize currentTime = _currentTime;

@synthesize asset = _asset;
@synthesize item = _item;
@synthesize player = _player;

- (void)dealloc
{
	[_player release];
	[_item release];
	[_asset release];
	[super dealloc];
}

- (NSString *)windowNibName
{
	return @"HMDocument";
}

- (void)windowControllerDidLoadNib:(NSWindowController *)aController
{
	[super windowControllerDidLoadNib:aController];
	
	NSRect wFrame = [[self windowForSheet] frame];
	NSRect vFrame = [_view frame];
	accessoryHeight = wFrame.size.height - vFrame.size.height;
	
	[self syncUI];
}

- (BOOL)readFromURL:(NSURL *)url ofType:(NSString *)typeName error:(NSError **)outError
{
	self.asset = [AVURLAsset URLAssetWithURL:url options:nil];
	
	NSString *tracksKey = @"tracks";
	[_asset loadValuesAsynchronouslyForKeys:[NSArray arrayWithObject:tracksKey]
						 completionHandler:
	 ^ {
		 dispatch_async(dispatch_get_main_queue(),
						^{
							self.item = [AVPlayerItem playerItemWithAsset:_asset];
							[_item addObserver:self
								   forKeyPath:@"status"
									  options:0
									  context:_item];
							[[NSNotificationCenter defaultCenter] addObserver:self
																	 selector:@selector(playerItemDidReachEnd:)
																		 name:AVPlayerItemDidPlayToEndTimeNotification
																	   object:_item];
							
							self.player = [AVPlayer playerWithPlayerItem:_item];
							[_player addObserver:self
									  forKeyPath:@"rate"
										 options:0
										 context:_player];
							
							[_player addPeriodicTimeObserverForInterval:CMTimeMake(4, 100)
																  queue:dispatch_get_main_queue()
															 usingBlock: ^(CMTime time) {
																 Float64 seconds = CMTimeGetSeconds(time);
																 self.currentTime = seconds;
															 }];
							
							AVPlayerLayer *layer = [AVPlayerLayer playerLayerWithPlayer:_player];
							[_view setWantsLayer:YES];
							[_view setLayer:layer];
						});
		 
	 }];
	
	return _asset ? YES : NO;
}


- (NSSize)fitSizeToSize:(NSSize)toSize
{
	if(!_asset) return toSize;
	
	CGSize movieSize = _asset.naturalSize;
	if(movieSize.width == 0) return toSize;
	
	CGFloat targetViewWidth = toSize.width;
	CGFloat targetViewHeight = targetViewWidth * (movieSize.height / movieSize.width);
	
	targetViewHeight += accessoryHeight;
	
	return NSMakeSize(targetViewWidth, targetViewHeight);
}
- (void)sizeTofitWidnow
{
	NSWindow *window = [self windowForSheet];
	NSRect frame = [window frame];
	NSSize newSize = [self fitSizeToSize:frame.size];
	frame.origin.y += frame.size.height - newSize.height;
	frame.size = newSize;
	[window setFrame:frame display:YES animate:NO];
}
- (void)syncUI
{
    if((_player.currentItem != nil) &&
        ([_player.currentItem status] == AVPlayerItemStatusReadyToPlay)) {
        _playButton.enabled = YES;
    }
    else {
        _playButton.enabled = NO;
    }
	
	if(_player.rate == 0) {
		_playButton.title = @">";
	} else {
		_playButton.title = @"||";
	}
}

#pragma mark -
#pragma mark KVC & KVO
- (void)observeValueForKeyPath:(NSString *)keyPath ofObject:(id)object change:(NSDictionary *)change context:(void *)context
{
	if(context == _item) {
		dispatch_async(dispatch_get_main_queue(),
                       ^{
						   [self sizeTofitWidnow];
						   
                           [self syncUI];
                       });
        return;
	}
	if(context == _player) {
		dispatch_async(dispatch_get_main_queue(),
                       ^{
                           [self syncUI];
                       });
        return;
	}
	[super observeValueForKeyPath:keyPath ofObject:object change:change context:context];
}

#pragma mark -
#pragma mark NSWindowDelegate
- (NSSize)windowWillResize:(NSWindow *)sender toSize:(NSSize)frameSize
{
	return [self fitSizeToSize:frameSize];
}
- (void)windowWillClose:(NSNotification *)notification
{
	[_player removeObserver:self forKeyPath:@"rate"];
	[_item removeObserver:self forKeyPath:@"status"];
}

#pragma mark -
#pragma mark Notifications
- (void)playerItemDidReachEnd:(NSNotification *)notification
{
	[_item seekToTime:kCMTimeZero];
}

#pragma mark -
#pragma mark Actions
- (IBAction)togglePlayAndPause:(id)sender
{
	if(_player.rate == 0) {
		[_player play];
	} else {
		[_player pause];
	}
}
- (IBAction)changeCurrentTime:(id)sender
{
	CGFloat timeValue = [sender doubleValue] * 1000.0;
	CMTime time = CMTimeMake(timeValue, 1000);
	[_item seekToTime:time];
}
- (IBAction)volumeUp:(id)sender
{
	_player.volume += 0.1;
}
- (IBAction)volumeDown:(id)sender
{
	if(_player.volume < 0.1) return;
	
	_player.volume -= 0.1;
}

- (BOOL)validateMenuItem:(NSMenuItem *)menuItem
{
	SEL action = [menuItem action];
	if(action == @selector(togglePlayAndPause:)) {
		if(_player.rate == 0) {
			[menuItem setTitle:@"Play"];
		} else {
			[menuItem setTitle:@"Pause"];
		}
	}
	return YES;
}

@end
