//
//  MyBarcodeScanner.m


#import "MyBarcodeScanner.h"
#import "MyiSightWindow.h"

#ifndef __LP64__
#import "SeqGrab.h"
#import "SGVideo.h"
#endif // ifndef __LP64__

#import "MyScanner.h"
#import "ZBarScanner.h"
#import "MyScanner.h"
#import <QTKit/QTKit.h>
#import "AllScanners.h"

#ifdef DEBUG
//#define CLICK_TO_SCAN 1  // Comment to have continous scanning during debug 
#endif

#define myPreferences [NSUserDefaults standardUserDefaults]
#define FRAMEWORK_BUNDLE [NSBundle bundleWithIdentifier:@"com.bruji.pediabase"]


@interface MyBarcodeScanner (Private)
- (void)processPixelBuffer:(CVPixelBufferRef)pixelBuffer;  //This is the function called to scan the barcode

- (void)foundBarcode:(NSString *)aBarcode;  //Let the program know a barcode was found

- (void)setupPreviewWindowWithTitle:(NSString *)aTitle crop:(CGRect)aCropRect;
- (void)clearGlobalFrequency;

// Helpers
- (SInt32)osVersion;
#ifndef __LP64__
- (void)setShortFocus:(QTCaptureDevice *)videoDevice;
#endif // __LP64__
- (void) openOldSequenceGrabber: (CGSize) displaySize cropArea: (CGRect) cropArea windowTitle: (NSString *) windowTitle aWindow: (NSWindow *) aWindow;

@end


@implementation MyBarcodeScanner



#pragma mark -
#pragma mark QTKit


- (void)scanForBarcodeWindow:(NSWindow *)aWindow {
	
	BOOL success = NO;
	NSError *error = nil;
	newHighResiSight = NO;
	CGRect cropArea = CGRectZero;
	CGSize displaySize = CGSizeMake(640.0, 480.0); //To be able to mirror the image fast without calculating the size in the preview view
	NSString *windowTitle = nil;

	
	// If the isight is already running then bring the window front
	if (previewWindow) {
		[previewWindow makeKeyAndOrderFront:self];
		return;
	}
	
	// We need at least version 721 of quicktime for the QTKit to be installed
	SInt32 quickTimeVersionNumber;
	Gestalt(gestaltQuickTime, &quickTimeVersionNumber);
	//NSLog(@"%x", quickTimeVersionNumber);
	if (quickTimeVersionNumber < 0x721000) {
		NSRunAlertPanel(NSLocalizedStringWithDefaultValue(@"Action Required", nil, [NSBundle mainBundle], nil, nil), NSLocalizedStringWithDefaultValue(@"NoQuickTime721", nil, [NSBundle mainBundle], @"The version of QuickTime installed is lower than 7.2.1, please install the latest QuickTime from http://www.apple.com/quicktime/download ", nil), @"OK", nil, nil);
		return;
	}
	
	
	QTCaptureDevice *videoDevice = [MyBarcodeScanner selectAndOpenVideoDevice:@"iSight ID"];
	
	
	//Find out if it's the new built-in High res iSight
	// imac 2.0 GHX 20inch first built-in version "ProductID_34049"
	// imac silver first high-res "ProductID_34050"
	// "FireWire iSight" for the old external one
	NSString *cameraDescription = [videoDevice modelUniqueID];
	NSString *cameraName = [videoDevice localizedDisplayName];
	if (cameraDescription == nil)
		cameraDescription = @"";
	
	int productIDNumber = 0;
	NSUInteger location;
	if ((location = [cameraDescription rangeOfString:@"ProductID_"].location) != NSNotFound) {
		NSString *idNumber = [cameraDescription substringFromIndex:location + 10];
		productIDNumber = [idNumber intValue];
	}
	
#ifdef DEBUG
	MyLog(@"Scanning Device: %@", cameraDescription);
	MyLog(@"ID: %d", productIDNumber);
	//NSLog(@"Name: %@", [videoDevice localizedDisplayName]);
#endif // DEBUG
	
	//0x8507
	
	// This device give a quarter image, can not get full 1280 x 1024 buffer
	/*
	if (cameraDescription && [cameraDescription rangeOfString:@"com.apple.QTKit.legacydevice"].location != NSNotFound) {
			displaySize = CGSizeMake(1280.0, 1024.0);
			setSizeOfBuffer = NO;
			windowTitle = @"Legacy";		
		}
	*/
	
	// John Rubock VendorID_1452 ProductID_34055
	
	//  ProductID_34050  iMac
	// ProductID_34049 Macbook CoreDuo 1,83 GHz
	//  34053  MacBook Air
	// They iMac 2009 has a fixed focus that is very far away at 2 feet. Although it has 34050 product id and version 2.3 of iSight
	// ### Would need to find one for testing and see what can be done
	//ProductID_34049
	// Apparently 34053 works well with the regular 640 x 480 version, it's the Mac Book Air
	if (productIDNumber >= 34050 && productIDNumber <= 34054 && productIDNumber != 34053 && ([cameraDescription rangeOfString:@"VendorID_1452"].location != NSNotFound)) { // [cameraDescription rangeOfString:@"ProductID_34050"].location != NSNotFound) {
		// Some newer cameras can do higher resolution, but we liked to keep all to the regular 640 x 480
		//displaySize = CGSizeMake(1280.0, 1024.0);
		//cropArea = CGRectMake(320.0, 544.0, 640.0, 480.0);
		//newHighResiSight = YES;
		windowTitle = @"Built-in iSight";
	}
	// 2.53 15" Intel Core 2 Duo, camera is only capable of 480 x 640
	// ProductID_34055
	else if ((productIDNumber == 34055) // || productIDNumber == 34050) // Try IMac here
		&& ([cameraDescription rangeOfString:@"VendorID_1452"].location != NSNotFound)) { // [cameraDescription rangeOfString:@"ProductID_34050"].location != NSNotFound) {
		// top middle of a 640 x 480 capture
		windowTitle = @"- iSight -";
		//cropArea = CGRectMake(160.0, 240.0, 320.0, 240.0);
		
	}
	// VendorID_1133 ProductID_2470  Logitech® QuickCam® Vision Pro for Mac®  960-by-720 pixels  960x720
	//ProductID_2448  ProductID_2470  // VendorID_1133 ProductID_2448"].location  Pro 9000
	// VendorID_1133 ProductID_2448  //PC version of the Logitech Pro 9000
	// VendorID_1118 ProductID_1885  Microsoft LifeCam
	// QTCompressionOptions   QTCompressionOptionsLosslessAppleIntermediateVideo
	else if ([cameraDescription rangeOfString:@"VendorID_1133"].location != NSNotFound
			 || ([cameraDescription rangeOfString:@"VendorID_1118"].location != NSNotFound && 
			  [cameraDescription rangeOfString:@"ProductID_1885"].location != NSNotFound)//Microsoft 
			 ) { //Logitech 
		
		if ([cameraDescription rangeOfString:@"ProductID_1885"].location != NSNotFound)
			windowTitle = @"Microsoft";
		else
			windowTitle = @"Logitech";

	}
	else if ([cameraDescription rangeOfString:@"VendorID_3277 ProductID_82"].location != NSNotFound) { //TerraCam X2
		//displaySize = CGSizeMake(1280.0, 1024.0); // Should really be 1280 x 960, full res at 1600 x 1200
		//cropArea = CGRectMake(320.0, 544.0, 640.0, 480.0);
		//newHighResiSight = YES;
		windowTitle = @"TerraCam X2";
	}
	else if (([cameraDescription rangeOfString:@"PYRO WebCam"].location != NSNotFound || [cameraDescription rangeOfString:@"ProductID_41271"].location != NSNotFound)) {
		//PYRO WEBCAM,VendorID_1266 ProductID_41271 
		windowTitle = @"PYRO WebCam";
	}
	else if (cameraName && cameraDescription && [cameraDescription rangeOfString:@"MV500i"].location != NSNotFound) { 
		// MV500i is Cannon camera that also needs the old iSight
		windowTitle = @"MV500i";
	}
	else {
		
		if ([cameraDescription rangeOfString:@"FireWire iSight"].location != NSNotFound)
			windowTitle = @"FireWire iSight";
		else if (cameraName)
			windowTitle = [NSString stringWithFormat:@"'%@'", cameraName];
		else
			windowTitle = @"External Camera";
	}
	
	//Init image barcode scanners for the capture size
	if (cropArea.size.width != 0) {
		scanners = [[AllScanners alloc] initWithCGRect:cropArea];
	}
	else {
		CGRect fullScanArea = CGRectZero;
		fullScanArea.size = displaySize;
		scanners = [[AllScanners alloc] initWithCGRect:fullScanArea];
	}
	
//#ifdef BETA
	//DLog(@"Window: %@", windowTitle);
//#endif
	
	if (videoDevice == nil) { //### Move this to the openVideoDevice function when leopard only
		NSRunAlertPanel(NSLocalizedStringWithDefaultValue(@"Action Required", nil, [NSBundle mainBundle], nil, nil), NSLocalizedStringWithDefaultValue(@"No iSight", nil, [NSBundle mainBundle], @"Please make sure your firewire camera is connected to your computer.", nil), @"OK", nil, nil);
		return;
	}
	else {
		
		/*//NSLog(@"attributes: %@", [videoDevice deviceAttributes]);
		 NSEnumerator *enumDevice = [[videoDevice formatDescriptions] objectEnumerator];
		 QTFormatDescription *nextDevice;
		 while (nextDevice = [enumDevice nextObject]) {
		 //NSLog(@"format: %@", [nextDevice localizedFormatSummary]);
		 }
		 */

#ifndef __LP64__
		if ([windowTitle isEqualToString:@"FireWire iSight"]
			//||  [windowTitle isEqualToString:@"Logitech"]
			) {
			/* || [cameraDescription rangeOfString:@"VendorID_1133 ProductID_2448"].location != NSNotFound */			
			
			static BOOL firstRun = YES;			
			if (firstRun) {
				firstRun = NO;
				[self setShortFocus:videoDevice];
			}
		}
#endif // __LP64__
		
		// Create the capture session
		mCaptureSession = [[QTCaptureSession alloc] init];
		
		//Add the video device to the session as a device input
		QTCaptureDeviceInput *mCaptureVideoDeviceInput = [[QTCaptureDeviceInput alloc] initWithDevice:videoDevice];
		success = [mCaptureSession addInput:mCaptureVideoDeviceInput error:&error];
		[mCaptureVideoDeviceInput release];
		if (!success) {
			MyLog(@"Error: video device could not be added as input: %@", [error localizedDescription]);
			[self closeiSight];
			return;
		}
		
		
		//newHighResiSight = NO;
		//displaySize = CGSizeMake(640.0, 480.0);
		//displaySize = CGSizeMake(1280.0, 1024.0);
//YUV422
		// k32ARGBPixelFormat may be used on Mac OS X 10.4.x
		// kCVPixelFormatType_32ARGB can be used in 10.5 kCVPixelFormatType_422YpCbCr8
		// k2vuyPixelFormat
		NSMutableDictionary *attributes = [NSMutableDictionary dictionaryWithObjectsAndKeys: 
						  [NSNumber numberWithDouble:displaySize.width], (id)kCVPixelBufferWidthKey, 
						  [NSNumber numberWithDouble:displaySize.height], (id)kCVPixelBufferHeightKey,
						  [NSNumber numberWithBool:YES], (id)kCVPixelBufferOpenGLCompatibilityKey,
						  [NSNumber numberWithUnsignedInt:k2vuyPixelFormat], (id)kCVPixelBufferPixelFormatTypeKey,
						  nil];
		
		// QTCaptureVideoPreviewOutput could be if frame rate is not so important
		QTCaptureDecompressedVideoOutput *mCaptureDecompress = [[QTCaptureDecompressedVideoOutput alloc] init];
		//QTCaptureVideoPreviewOutput *mCaptureDecompress = [[QTCaptureVideoPreviewOutput alloc] init];
		[mCaptureDecompress setDelegate:self];
		[mCaptureDecompress setPixelBufferAttributes:attributes];
		if ([mCaptureDecompress respondsToSelector:@selector(setAutomaticallyDropsLateVideoFrames:)])
			[mCaptureDecompress setAutomaticallyDropsLateVideoFrames:YES]; //!!! 10.6 only
		success = [mCaptureSession addOutput:mCaptureDecompress error:&error];
		[mCaptureDecompress release];
		if (!success) {
			MyLog(@"Error: could not add output device: %@", [error localizedDescription]);
			[self closeiSight];
			return;
		}
		
		// Associate the capture view in the UI with the session
		[self setupPreviewWindowWithTitle:windowTitle crop:cropArea];
		//[previewView setHighResiSight:newHighResiSight];
		[previewView setCaptureSize:displaySize];
		//if ([aScanner isKindOfClass:[ZBarScanner class]])
			//[previewView setDefaultColor:[NSColor greenColor]];
		//else
		//[previewView setDefaultColor:[NSColor redColor]];
		[previewView setCropRect:cropArea];
		[previewView setMirrored:mirrored]; //Has to come after the displaySize is set, as the mirror filter needs that information
		[scanners setPreviewView:previewView];

		clockFrequency = CVGetHostClockFrequency();
		
		[mCaptureSession startRunning];				
	}
}



- (void)setupPreviewWindowWithTitle:(NSString *)aTitle crop:(CGRect)aCropRect {
	
	lastDateScan = [[NSDate date] retain];
	
	// set up a preview window for the newly added video channel
	NSRect screenRect = [[[NSApp mainWindow] screen] visibleFrame];
	//NSRect windowRect = [videoChannel previewBounds];
	NSRect windowRect = NSMakeRect(0, 0, 640, 480);
	//NSRect windowRect = NSMakeRect(0, 0, 1280, 1024);
	if (aCropRect.size.width && aCropRect.size.width != 640) {
		windowRect.size.width = aCropRect.size.width;
		windowRect.size.height = aCropRect.size.height;
	}
	
	
	//if (windowRect.size.width == 0. || windowRect.size.height == 0.)
	//windowRect = [videoChannel srcVideoBounds];
	
	windowRect.origin.x = screenRect.origin.x + 16;
	
	windowRect.origin.y = screenRect.origin.y + screenRect.size.height - windowRect.size.height - 22;
	
	
	// Here's where we create a window to hold 
	// the sgvideo object's preview view
	previewWindow = [[MyiSightWindow alloc] initWithContentRect:windowRect 
															   styleMask:NSTitledWindowMask | NSClosableWindowMask
																 backing:NSBackingStoreBuffered 
																   defer:YES
																  screen:[[NSApp mainWindow] screen]];
	
	[previewWindow setWorksWhenModal:YES];
	
	[previewWindow setReleasedWhenClosed:YES];
	[previewWindow setFrameAutosaveName:@"iSightWindow"];
	
	previewView = [[SampleCIView alloc] initWithFrame:windowRect];
	//[[previewWindow contentView] addSubview:previewView];
	[previewWindow setContentView:previewView];
	[previewView release];
	
	
	[previewWindow setTitle:aTitle];
	
	//[[videoChannel previewView] setAutoresizingMask: NSViewWidthSizable | NSViewHeightSizable];
	
	[previewWindow setDelegate:self];
	[previewWindow makeKeyAndOrderFront:self];
	
	[scanners clearGlobalFrequency];
	[lastBarcode release];
	lastBarcode = nil;
	//lastDateScan = [NSDate date];
	
		
}

/*
- (void)captureOutput:(QTCaptureOutput *)captureOutput didDropVideoFrameWithSampleBuffer:(QTSampleBuffer *)sampleBuffer fromConnection:(QTCaptureConnection *)connection {
		//NSLog(@"Frame Dropped");
}
*/

- (void)captureOutput:(QTCaptureOutput *)captureOutput didOutputVideoFrame:(CVImageBufferRef)videoFrame withSampleBuffer:(QTSampleBuffer *)sampleBuffer fromConnection:(QTCaptureConnection *)connection {
	
	
	// Drop frames if they fall behind due to increased processing time on slower computers
	// MacBookPro .02 and .03 delay on coming in is normal
	uint64_t ht = CVGetCurrentHostTime(), iht = [[sampleBuffer attributeForKey:QTSampleBufferHostTimeAttribute] unsignedLongLongValue];
	double hts = ht/clockFrequency, ihts = iht/clockFrequency;
	//printf("time: %f vs. %f\n ", hts, ihts);
	
	if(hts > ihts + 0.1) { // 1/10 of a second
		//NSLog(@"Drop Frame: %f", hts);
		return;
	}
	
	
	// Changes here don't reflect captures with the old iSight need to update displayData:trackingFlags:displayTime:displayDuration:validTimeFlags:	
	if (previewWindow != nil ) {
		//NSLog(@"create image");
		CIImage * ciImage = [CIImage imageWithCVImageBuffer:videoFrame];
		[previewView setImage:ciImage];	
		
#ifdef DEBUG	
#ifdef CLICK_TO_SCAN
		if (scanBarcode == NO) {
			return;
		}
		scanBarcode = NO;
#endif // CLICK_TO_SCAN
#endif // DEBUG

		
		[previewView setGoodScan:NO];
		NSString *aBarcode = [scanners processVideoBuffer:videoFrame];
		if (aBarcode)
			[self foundBarcode:aBarcode];

		//[pool release];
		
	}
}

- (void)dealloc {
	[self closeiSight];
	[delegate release]; delegate = nil;
	[scanners release]; 
	//[previewWindow release];
	[super dealloc];
}


//When the window closes it's time to close the iSight as well and the timer
- (BOOL)closeiSight {

	//NSLog(@"Close iSight: %@", mCaptureSession);
	BOOL returnValue = NO;
	if (mCaptureSession) {
		[mCaptureSession stopRunning];
		QTCaptureDevice *captureDevice = [[[mCaptureSession inputs] lastObject] device];
		if ([captureDevice isOpen])
			[captureDevice close];
		
		[mCaptureSession release];
		mCaptureSession = nil;
		
		returnValue = YES;
	}
#ifndef __LP64__
	else if (mGrabber) {
		[mGrabber stop];
		NSArray *channels = [mGrabber channels];
		if ([channels count]) {
			
			SGChan* doomedChan = [channels objectAtIndex:0];
			[mGrabber removeChannel:doomedChan];
			
			returnValue = YES;
		}
		[mGrabber release]; mGrabber = nil;
	}
#endif // __LP64__
	
	if (returnValue) {
		if ([delegate respondsToSelector:@selector(iSightWillClose)]) {
			[delegate iSightWillClose];
		}
		
		[scanners release]; scanners = nil;
		[lastBarcode release]; lastBarcode = nil;
		
		//[previewWindow release];
		[previewWindow close]; // NSWindow is released on close 
		previewWindow = nil;
		previewView = nil;		
		
	}

	
	//[aScanner performSelector:@selector(release) withObject:nil afterDelay:0.0];
	//[aScanner release]; aScanner = nil;

	[lastDateScan release]; lastDateScan = nil; 
	return returnValue;
}


#pragma mark -
#pragma mark Barcode

// Delegate method for add window only called when the red button is used to close the window
// Needed here to trigger the closeiSight: method that cleans up sequence grabber
- (BOOL)windowShouldClose:(id)sender {	
    [self closeiSight];
    return YES;
}


// Send a message to the delegate that we found a barcode
// Close the window if stayOpen is negative
// Because this message is sent delayed with performSelector so as to not close the window in the middle of displaying the buffer it
// might be called twice
- (void)foundBarcode:(NSString *)aBarcode {
	[scanners clearGlobalFrequency];

	// Has to go before gotBarcode: on the main thread as it sends a barcode will close message that brings up the find panel
	if (stayOpen == NO)
		[self performSelectorOnMainThread:@selector(closeiSight) withObject:nil waitUntilDone:NO];

	// Only send barcode that we didn't previously scan
	// lastBarcode is reset to nil when calling scanBarcode
	// Scan barcodes with a separation of at least half a second
	if ([lastDateScan timeIntervalSinceNow] < -0.5 && (lastBarcode == nil || ![lastBarcode isEqualToString:aBarcode])) {
		[lastDateScan release];
		lastDateScan = [[NSDate date] retain];
		[(NSSound *)[NSSound soundNamed:@"Morse"] play];	
		//[delegate gotBarcode:aBarcode];
		[lastBarcode release];
		lastBarcode = [aBarcode retain];
		
		[delegate performSelectorOnMainThread:@selector(gotBarcode:) withObject:[[aBarcode retain] autorelease] waitUntilDone:NO];
	}
}



#pragma mark -
#pragma mark Helpers


+ (QTCaptureDevice *)selectAndOpenVideoDevice:(NSString *)prefsDefaultKey {
	QTCaptureDevice *videoDevice = nil;
	NSMutableArray *videoDevices = [NSMutableArray array];
	
	//Get default if there already is one and control is not held down
	BOOL selectDefault = YES;
	NSUInteger flags = [[NSApp currentEvent] modifierFlags];
	if (flags & NSControlKeyMask && !(flags & NSShiftKeyMask))
		selectDefault = NO;
	
	if (selectDefault) {
		NSString *defaultDevice = [myPreferences objectForKey:prefsDefaultKey];
		videoDevice = [QTCaptureDevice deviceWithUniqueID:defaultDevice];
	}
	
	// default not found run the regular check 
	if (videoDevice == nil) {
		
		[videoDevices addObjectsFromArray:[QTCaptureDevice inputDevicesWithMediaType:QTMediaTypeVideo]];
		[videoDevices addObjectsFromArray:[QTCaptureDevice inputDevicesWithMediaType:QTMediaTypeMuxed]];
		
		/*
		 NSEnumerator *enumDevice = [videoDevices objectEnumerator];
		 NSMutableArray *possibleCameras = [NSMutableArray array];
		 QTCaptureDevice *nextDevice;
		 while (nextDevice = [enumDevice nextObject]) {
		 if ([nextDevice hasMediaType:QTMediaTypeVideo] || [nextDevice hasMediaType:QTMediaTypeMuxed])
		 [possibleCameras addObject:nextDevice];
		 }
		 */
		
		NSUInteger count = [videoDevices count];
		if (count == 1) {
			videoDevice = [videoDevices objectAtIndex:0];
		}
		else if (count > 1) {
			NSString *firstDevice = [[videoDevices objectAtIndex:0] localizedDisplayName];
			NSString *secondDevice = [[videoDevices objectAtIndex:1] localizedDisplayName];
			NSString *thirdDevice = nil;
			if (count > 2)
				thirdDevice = [[videoDevices objectAtIndex:2] localizedDisplayName];
			
			// isConnected  isInUseByAnotherApplication
			NSInteger buttonPressed = NSRunAlertPanel(NSLocalizedStringWithDefaultValue(@"Action Required", nil, FRAMEWORK_BUNDLE, nil, nil), 
													  NSLocalizedStringWithDefaultValue(@"Several video sources", nil, FRAMEWORK_BUNDLE, @"Several video sources have been found. Which one would you like to use?", nil), 
													  firstDevice, 
													  secondDevice,
													  thirdDevice);
			
			if (buttonPressed == NSAlertDefaultReturn) {
				videoDevice = [videoDevices objectAtIndex:0];
			}
			else if (buttonPressed == NSAlertAlternateReturn) {
				videoDevice = [videoDevices objectAtIndex:1];
			}
			else if (buttonPressed == NSAlertOtherReturn) {
				videoDevice = [videoDevices objectAtIndex:2];
			}
			
			//Save as default device to use
			NSString *uniqueID = [videoDevice uniqueID];
			[myPreferences setObject:uniqueID forKey:@"iSight ID"];
			
		}
	}
	
	NSError *error = nil;
	BOOL success = [videoDevice open:&error];	
	if (!success) {
		// Write error to the console log 
		MyLog(@"Error: failed to opened selected video device: %@", [error localizedDescription]);
		
		// Try one last ditch attempt at the default devices for Video and Muxed
		videoDevice = [QTCaptureDevice defaultInputDeviceWithMediaType:QTMediaTypeVideo];
		if (videoDevice)
			success = [videoDevice open:&error];
		
		if (!success) {			
			videoDevice = [QTCaptureDevice defaultInputDeviceWithMediaType:QTMediaTypeMuxed];
			if (videoDevice)
				success = [videoDevice open:&error];
			
			if (!success) {
				videoDevice = nil;
				MyLog(@"Error: failed to opened default video device: %@", [error localizedDescription]);
			}	
		}
	}
	
	return videoDevice;	
}


#ifndef __LP64__
- (void)setShortFocus:(QTCaptureDevice *)videoDevice {
	//close QTKit device
	if ([videoDevice isOpen])
		[videoDevice close];
	
	SGChannel           mChan;
	SeqGrabComponent    mSeqGrab;
	OpenADefaultComponent(SeqGrabComponentType, 0, &mSeqGrab);
	
	SGInitialize(mSeqGrab);
	ComponentResult errorChannel = SGNewChannel(mSeqGrab, VideoMediaType, &mChan);
	
	if (errorChannel == 0) {
		
		/*
		 Rect setVideoRec;
		 SetRect(&setVideoRec, 0, 0, 640, 480);
		 //NSLog(@"set Rect: %d, %d", setVideoRec.right, setVideoRec.bottom);
		 SGSetChannelBounds(mChan, &setVideoRec);
		 */
		
		// Set the focus value helps with external iSights
		// Thanks to Wil Shipley for the focus code: http://lists.apple.com/archives/quicktime-api/2004/Mar/msg00257.html
		ComponentInstance vd = SGGetVideoDigitizerComponent(mChan);
		if (vd) {
			
			//Old external camera, laod old code for capturing to be able to set the focus on the camera
			QTAtomContainer iidcFeaturesAtomContainer = NULL;
			QTAtom featureAtom = 0.0;
			QTAtom typeAndIDAtom = 0.0;
			QTAtom featureSettingsAtom = 0.0;
			QTNewAtomContainer(&iidcFeaturesAtomContainer);
			
			
			QTInsertChild(iidcFeaturesAtomContainer, kParentAtomIsContainer, vdIIDCAtomTypeFeature, 1, 0, 0, nil, &featureAtom);
			VDIIDCFeatureAtomTypeAndID featureAtomTypeAndID = {vdIIDCFeatureFocus, vdIIDCGroupMechanics, {5}, vdIIDCAtomTypeFeatureSettings, vdIIDCAtomIDFeatureSettings};
			QTInsertChild(iidcFeaturesAtomContainer, featureAtom, vdIIDCAtomTypeFeatureAtomTypeAndID, vdIIDCAtomIDFeatureAtomTypeAndID, 0, sizeof(featureAtomTypeAndID), &featureAtomTypeAndID, &typeAndIDAtom);
			VDIIDCFeatureSettings featureSettings = {{0, 0, 0, 0.0, 0.0}, {vdIIDCFeatureFlagOn | vdIIDCFeatureFlagManual | vdIIDCFeatureFlagRawControl, 0.35}};
			QTInsertChild(iidcFeaturesAtomContainer, featureAtom, vdIIDCAtomTypeFeatureSettings, vdIIDCAtomIDFeatureSettings, 0, sizeof(featureSettings), &featureSettings, &featureSettingsAtom);
			VDIIDCSetFeatures(vd, iidcFeaturesAtomContainer);
		}
		
		
		// Set saturation to black and white
		//unsigned short newSaturation = 0;
		//VDSetSaturation(vd, &newSaturation);
		
	}
	
	SGDisposeChannel(mSeqGrab, mChan);
	CloseComponent(mSeqGrab);
	[NSThread sleepUntilDate:[NSDate dateWithTimeIntervalSinceNow:0.2]];
	
	//Re open device
	NSError *error;
	BOOL success = [videoDevice open:&error];
	
	// Write error to the console log 
	if (!success) {
		videoDevice = nil;
		MyLog(@"Error: video device could not be re-opened after changing settings: %@", [error localizedDescription]);
		[self closeiSight];
		return;
	}	
}
#endif // __LP64__

#pragma mark -
#pragma mark sharedInstance

static MyBarcodeScanner *sharedInstance = nil;

+ (MyBarcodeScanner *)sharedInstance {	
	if (sharedInstance == nil) {
		//Make mirrored the default now, with the smooth Core Image Mirror
		[[NSUserDefaults standardUserDefaults] registerDefaults:[NSDictionary dictionaryWithObject:[NSNumber numberWithBool:YES] forKey:@"Mirror iSight"]];
		
		sharedInstance = [[self alloc] init];
	}
	return sharedInstance;
}
- (void)release {
}
- (id)retain {
    return self;
}
- (NSUInteger)retainCount {
    return UINT_MAX;
}
+ (id)allocWithZone:(NSZone *)zone {
	if (sharedInstance == nil) {
		return [super allocWithZone:zone];
	}
    return sharedInstance;
}
- (id)copyWithZone:(NSZone *)zone {
    return self;
}
- (id)autorelease {
    return self;
}

#pragma mark Accessors

- (void)setDelegate:(id)aDelegate {
	[delegate release];
	delegate = [aDelegate retain];
}

- (void)setStaysOpen:(BOOL)stayOpenValue {
	stayOpen = stayOpenValue;
}

- (void)setMirrored:(BOOL)mirroredValue {
	mirrored = mirroredValue;
	[previewView setMirrored:mirroredValue];
}



#pragma mark -
#pragma mark Debug only

#ifdef DEBUG

- (void)setScanBarcode:(BOOL)aBoolValue {
	scanBarcode = aBoolValue;
}

#endif // DEBUG

@end

