//
//  BEMediaMarkerBooksExporter.m
//  BooksExporter
//
//  Created by Hori,Masaki on 11/03/01.
//  Copyright 2011 masakih. All rights reserved.
//

#import "BEMediaMarkerBooksExporter.h"
#import "BEBookInformation.h"


@implementation BEMediaMarkerBooksExporter
- (NSString *)statusNameWithBook:(BEBookInformation *)book
{
	NSString *result = nil;
	switch([book.status intValue]) {
		case 0:
			result = NSLocalizedString(@"MIDOKU", @"MIDOKU");
			break;
		case 1:
			result = @"-";
			break;
		case 2:
			result = NSLocalizedString(@"DOKUCHUU", @"DOKUCHUU");
			break;
		case 3:
			result = NSLocalizedString(@"DOKURYOU", @"DOKURYOU");
			break;
		case 4:
			result = @"-";
			break;
		default:
			return @"";
	}
	return result;
}
- (id)init
{
	self = [super init];
	if(self) {
		registerDateFormatter = [[NSDateFormatter alloc] init];
		[registerDateFormatter setDateFormat:@"YYYY/MM/dd' 'HH':'mm"];
		readDateFormatter = [[NSDateFormatter alloc] init];
		[readDateFormatter setDateFormat:@"YYYY/MM/dd"];
	}
	return self;
}
- (void)dealloc
{
	[registerDateFormatter release];
	[readDateFormatter release];
	[super dealloc];
}
- (NSString *)lineForBook:(BEBookInformation *)book
{
	
	return [NSString stringWithFormat:@"\"%@\",\"%@\",\"%@\",\"%@\",\"%@\",\"%@\",\"%@\",\"%@\"",
			doubleQuoteQuotedString(book.category),
			doubleQuoteQuotedString(book.asin),
			doubleQuoteQuotedString([registerDateFormatter stringFromDate:book.registerDate]),
			doubleQuoteQuotedString(tagsString(book.tags)),
			doubleQuoteQuotedString(book.review),
			doubleQuoteQuotedString([book.rating stringValue]),
			doubleQuoteQuotedString([self statusNameWithBook:book]),
			doubleQuoteQuotedString([readDateFormatter stringFromDate:book.readDate])];
}

@end
