//
//  AmaonLookup.m
//  BarcodeScanner
//
//  Created by Hori,Masaki on 11/02/27.
//  Copyright 2011 masakih. All rights reserved.
//

#import "BEAmazonLookup.h"
#import "BEBookInformation.h"

#import "BEAmazonRequestGenerator.h"

NSXMLElement *firstElementForName(NSXMLElement *parent, NSString *name)
{
	NSArray *children = [parent elementsForName:name];
	if(!children || [children count] == 0) return nil;
	return [children objectAtIndex:0];
}

NSString* deodeURIComponent(NSString* s) {
	return [((NSString*)CFURLCreateStringByReplacingPercentEscapesUsingEncoding(kCFAllocatorDefault,
																				(CFStringRef)s,
																				NULL,
																				kCFStringEncodingUTF8)) autorelease];
}

@implementation BEAmazonLookup
static BEAmazonLookup *sharedInstance = nil;

+ (BEAmazonLookup *)sharedInstance
{
	if (sharedInstance == nil) {
		sharedInstance = [[super allocWithZone:NULL] init];
	}
    return sharedInstance;
}

+ (id)allocWithZone:(NSZone *)zone
{
    return [[self sharedInstance] retain];
}

- (id)copyWithZone:(NSZone *)zone
{
    return self;
}

- (id)retain
{
    return self;
}

- (NSUInteger)retainCount
{
    return NSUIntegerMax;  //denotes an object that cannot be released
}

- (void)release
{
    //do nothing
}

- (id)autorelease
{
    return self;
}


- (void)parseError:(NSXMLElement *)items
{
	id request = firstElementForName(items, @"Request");
	id errors = firstElementForName(request, @"Errors");
	id error = firstElementForName(errors, @"Error");
	if(error) {
		NSLog(@"%@", error);
		NSBeep();
	}
}

- (void)lookupBook:(BEBookInformation *)book
{
	BEAmazonRequestGenerator *generator = [BEAmazonRequestGenerator generatorWithBook:book];	
	NSURLRequest *req = [generator request];
	NSURLResponse *response = nil;
	NSError *error = nil;
	NSData *data = [NSURLConnection sendSynchronousRequest:req
										 returningResponse:&response
													 error:&error];
	if(!data) {
		NSString *errorString = @"";
		if(error) {
			errorString = [error localizedDescription];
		}
		NSLog(@"##### ERROR ####\nResponse -> %@\n%@", response, errorString);
		return;
	}
		
	NSXMLDocument *xml = [[[NSXMLDocument alloc] initWithData:data
													  options:0
														error:&error] autorelease];
//	NSData *xmlData = [xml XMLDataWithOptions:NSXMLNodePrettyPrint];
//	NSString *xmlString = [[[NSString alloc] initWithData:xmlData encoding:NSUTF8StringEncoding] autorelease];	
//	NSLog(@"result -> \n%@", xmlString);
	
	NSXMLElement *root = [xml rootElement];
	
	id items = firstElementForName(root, @"Items");
	id item = firstElementForName(items, @"Item");
	if(!item) {
		[self parseError:items];
		return;
	}
	
	id asin = firstElementForName(item, @"ASIN");
	book.asin = [asin objectValue];
	
	id itemAttrs = firstElementForName(item, @"ItemAttributes");
	id title = firstElementForName(itemAttrs, @"Title");
	book.title = [title objectValue];
	id amazonISBN = firstElementForName(itemAttrs, @"ISBN");
	book.amazonISBN = [amazonISBN objectValue];
	id author = firstElementForName(itemAttrs, @"Author");
	book.author = [author objectValue];
	id manufacturer = firstElementForName(itemAttrs, @"Manufacturer");
	book.manufacturer = [manufacturer objectValue];
	id publicationDate = firstElementForName(itemAttrs, @"PublicationDate");
	book.publicationDate = [publicationDate objectValue];
}

- (void)lookupBooks:(NSArray *)books
{
	for(id book in books) {
		[self lookupBook:book];
	}
}

@end
