//
//  BSIPReferenceViewController.m
//  BSInlinePreviewer
//
//  Created by 堀 昌樹 on 12/08/06.
//  Copyright (c) 2012年 __MyCompanyName__. All rights reserved.
//

#import "BSIPReferenceViewController.h"
#import "BSIThumbnailSizeView.h"

@interface BSIPReferenceViewController ()

@end

@implementation BSIPReferenceViewController
@synthesize sizeView;

- (id)init
{
	return [super initWithNibName:NSStringFromClass([self class]) bundle:[NSBundle bundleForClass:[self class]]];
}


- (void)awakeFromNib
{
	[self willChangeValueForKey:@"sizeString"];
    self.sizeView.imageSize = _thumbailSize;
	[self didChangeValueForKey:@"sizeString"];
    [sizeView addObserver:self
			   forKeyPath:@"imageSize"
				  options:0
				  context:sizeView];
}

+ (NSSet *)keyPathsForValuesAffectingThumbnailWidth
{
	return [NSSet setWithObject:@"thumbnailSize"];
}
+ (NSSet *)keyPathsForValuesAffectingThumbnailSize
{
	return [NSSet setWithObject:@"thumbnailWidth"];
}
- (CGFloat)thumbnailWidth
{
	return self.thumbnailSize.width;
}
- (void)setThumbnailWidth:(CGFloat)thumbnailWidth
{
	self.thumbnailSize = NSMakeSize(thumbnailWidth, thumbnailWidth);
	self.sizeView.imageSize = self.thumbnailSize;
}
- (NSSize)thumbnailSize
{
	return sizeView.imageSize;
}
- (void)setThumbnailSize:(NSSize)thumbnailSize
{
	if(NSEqualSizes(_thumbailSize, thumbnailSize)) return;
	
	_thumbailSize = thumbnailSize;
	sizeView.imageSize = thumbnailSize;
}

- (NSString *)sizeString
{
	return [NSString stringWithFormat:@"%.0f %C %.0f", self.thumbnailSize.width, 0x00D7, self.thumbnailSize.height];
}

+(NSSet *)keyPathsForValuesAffectingSizeString
{
	return [NSSet setWithObject:@"thumbnailSize"];
}
- (void)observeValueForKeyPath:(NSString *)keyPath ofObject:(id)object change:(NSDictionary *)change context:(void *)context
{
	if(context == sizeView) {
		[self willChangeValueForKey:@"thumbnailSize"];
		_thumbailSize = sizeView.imageSize;
		[self didChangeValueForKey:@"thumbnailSize"];
		return;
	}
	
	[super observeValueForKeyPath:keyPath ofObject:object change:change context:context];
}
@end
