/**
Asprintf

Copyright (c) 2014 Akira Sasaki

This software is released under the MIT License.

http://opensource.org/licenses/mit-license.php

*/

#ifndef ASPRINTF_H
#define ASPRINTF_H

#include <stdio.h>
#include <stdarg.h>

#ifdef UNIT_TEST
int (*mockable_vsnprintf1)(
    char * restrict str, size_t size,
    const char * restrict format, va_list ap);
int (*mockable_vsnprintf2)(
    char * restrict str, size_t size,
    const char * restrict format, va_list ap);
void *(*mockable_malloc)(size_t size);
void (*mockable_free)(void *ptr);
#endif

int vasprintf(char **strp, const char *format, va_list ap)
    __attribute__((format(printf, 2, 0)));
int asprintf(char **strp, const char *format, ...)
    __attribute__((format(printf, 2, 3)));

#endif
