/**
Asprintf

Copyright (c) 2014 Akira Sasaki

This software is released under the MIT License.

http://opensource.org/licenses/mit-license.php

*/

#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>

#include "asprintf.h"

#ifdef UNIT_TEST
int (*mockable_vsnprintf1)(
    char * restrict str, size_t size,
    const char * restrict format, va_list ap) = vsnprintf;
int (*mockable_vsnprintf2)(
    char * restrict str, size_t size,
    const char * restrict format, va_list ap) = vsnprintf;
void *(*mockable_malloc)(size_t size) = malloc;
void (*mockable_free)(void *ptr) = free;
#else
#define mockable_vsnprintf1 vsnprintf
#define mockable_vsnprintf2 vsnprintf
#define mockable_malloc malloc
#define mockable_free free
#endif

static int do_vasprintf(
    char **strp, const char *format, va_list ap, va_list ap_copy)
{
    *strp = NULL;

    int size1 = mockable_vsnprintf1(NULL, 0, format, ap_copy);
    if (size1 == -1) {
        return -1;
    }

    int alloc_size = size1 + 1;
    *strp = mockable_malloc(alloc_size);
    if (*strp == NULL) {
        return -1;
    }

    int size2 = mockable_vsnprintf2(*strp, alloc_size, format, ap);
    if (size2 != size1) {
        return -1;
    }

    return size1;
}

int vasprintf(char **strp, const char *format, va_list ap)
{
    va_list ap_copy;

    va_copy(ap_copy, ap);
    int size = do_vasprintf(strp, format, ap, ap_copy);
    va_end(ap_copy);
    if (size == -1) {
        mockable_free(*strp);
        *strp = NULL;
        return -1;
    }

    return size;
}

int asprintf(char **strp, const char *format, ...)
{
    va_list ap;

    va_start(ap, format);
    int size = vasprintf(strp, format, ap);
    va_end(ap);

    return size;
}
