/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.users;

import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class User
implements Serializable,
Comparable<User> {
    static final long serialVersionUID = 8691571286358652288L;
    private String email;
    private String authDomain;
    private String userId;

    private User() {
    }

    public User(String email, String authDomain) {
        this(email, authDomain, null);
    }

    public User(String email, String authDomain, String userId) {
        if (email == null) {
            throw new NullPointerException("email must be specified");
        }
        if (authDomain == null) {
            throw new NullPointerException("authDomain must be specified");
        }
        this.email = email;
        this.authDomain = authDomain;
        this.userId = userId;
    }

    public String getNickname() {
        int indexOfDomain = this.email.indexOf("@" + this.authDomain);
        if (indexOfDomain == -1) {
            return this.email;
        }
        return this.email.substring(0, indexOfDomain);
    }

    public String getAuthDomain() {
        return this.authDomain;
    }

    public String getEmail() {
        return this.email;
    }

    public String getUserId() {
        return this.userId;
    }

    public String toString() {
        return this.email;
    }

    public boolean equals(Object object) {
        if (!(object instanceof User)) {
            return false;
        }
        User user = (User)object;
        return user.email.equals(this.email) && user.authDomain.equals(this.authDomain);
    }

    public int hashCode() {
        return 17 * this.email.hashCode() + this.authDomain.hashCode();
    }

    @Override
    public int compareTo(User user) {
        return this.email.compareTo(user.email);
    }
}

